/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.Mapper;
import org.apache.maven.shared.model.fileset.SetBase;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FileSetXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public FileSetXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public FileSetXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public FileSet read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public FileSet read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public FileSet read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public FileSet read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private FileSet parseFileSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                fileSet.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lineEnding", null, parsed)) {
                fileSet.setLineEnding(this.interpolatedTrimmed(parser.nextText(), "lineEnding"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "followSymlinks", null, parsed)) {
                fileSet.setFollowSymlinks(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "followSymlinks"), "followSymlinks", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                fileSet.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                fileSet.setUseDefaultExcludes(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useDefaultExcludes"), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                fileSet.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                fileSet.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mapper", null, parsed)) {
                fileSet.setMapper(this.parseMapper(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return fileSet;
    }

    private Mapper parseMapper(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Mapper mapper = new Mapper();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                mapper.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "from", null, parsed)) {
                mapper.setFrom(this.interpolatedTrimmed(parser.nextText(), "from"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "to", null, parsed)) {
                mapper.setTo(this.interpolatedTrimmed(parser.nextText(), "to"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "classname", null, parsed)) {
                mapper.setClassname(this.interpolatedTrimmed(parser.nextText(), "classname"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return mapper;
    }

    private SetBase parseSetBase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        SetBase setBase = new SetBase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "followSymlinks", null, parsed)) {
                setBase.setFollowSymlinks(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "followSymlinks"), "followSymlinks", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                setBase.setOutputDirectory(this.interpolatedTrimmed(parser.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "useDefaultExcludes", null, parsed)) {
                setBase.setUseDefaultExcludes(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "useDefaultExcludes"), "useDefaultExcludes", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                setBase.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                setBase.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileMode", null, parsed)) {
                setBase.setFileMode(this.interpolatedTrimmed(parser.nextText(), "fileMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directoryMode", null, parsed)) {
                setBase.setDirectoryMode(this.interpolatedTrimmed(parser.nextText(), "directoryMode"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mapper", null, parsed)) {
                setBase.setMapper(this.parseMapper(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return setBase;
    }

    private FileSet read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        FileSet fileSet = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"fileSet".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'fileSet' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'fileSet'", parser, null);
                }
                fileSet = this.parseFileSet(parser, strict);
                fileSet.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return fileSet;
        }
        throw new XmlPullParserException("Expected root element 'fileSet' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

