/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jacoco.core.tools.ExecDumpClient;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.AbstractJacocoMojo;

@Mojo(name="dump", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class DumpMojo
extends AbstractJacocoMojo {
    @Parameter(property="jacoco.destFile", defaultValue="${project.build.directory}/jacoco.exec")
    private File destFile;
    @Parameter(property="jacoco.append", defaultValue="true")
    private boolean append;
    @Parameter(property="jacoco.dump", defaultValue="true")
    private boolean dump;
    @Parameter(property="jacoco.reset", defaultValue="false")
    private boolean reset;
    @Parameter(property="jacoco.address")
    private String address;
    @Parameter(property="jacoco.port", defaultValue="6300")
    private int port;
    @Parameter(property="jacoco.retryCount", defaultValue="10")
    private int retryCount;

    @Override
    public void executeMojo() throws MojoExecutionException {
        ExecDumpClient client = new ExecDumpClient(){

            @Override
            protected void onConnecting(InetAddress address, int port) {
                DumpMojo.this.getLog().info((CharSequence)String.format("Connecting to %s:%s", address, port));
            }

            @Override
            protected void onConnectionFailure(IOException exception) {
                DumpMojo.this.getLog().info((CharSequence)exception.getMessage());
            }
        };
        client.setDump(this.dump);
        client.setReset(this.reset);
        client.setRetryCount(this.retryCount);
        try {
            ExecFileLoader loader = client.dump(this.address, this.port);
            if (this.dump) {
                this.getLog().info((CharSequence)String.format("Dumping execution data to %s", this.destFile.getAbsolutePath()));
                loader.save(this.destFile, this.append);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to dump coverage data", (Exception)e);
        }
    }
}

