/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.graphics.Texture;
import y111studios.AssetPaths;

public class AssetLibrary {
    public AssetManager manager;
    private boolean initialised = false;

    private AssetLibrary() {
    }

    public static AssetLibrary getInstance() {
        return Holder.INSTANCE;
    }

    public void init() {
        if (this.initialised) {
            throw new IllegalStateException("Asset Library is already initialised");
        }
        this.manager = new AssetManager(new InternalFileHandleResolver());
        this.initialised = true;
        this.preload();
    }

    public void dispose() {
        this.manager.dispose();
        this.initialised = false;
    }

    private void preload() {
        for (AssetPaths path : AssetPaths.values()) {
            this.manager.load(path.getPath(), Texture.class);
        }
        this.manager.finishLoading();
    }

    private static class Holder {
        private static final AssetLibrary INSTANCE = new AssetLibrary();

        private Holder() {
        }
    }
}

