/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.viewport.Viewport;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.buildings.premade_variants.AccommodationVariant;
import y111studios.buildings.premade_variants.CateringVariant;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.RecreationVariant;
import y111studios.buildings.premade_variants.TeachingVariant;
import y111studios.buildings.premade_variants.VariantProperties;
import y111studios.utils.MenuTab;
import y111studios.utils.UnreachableException;

public class BuildingMenu {
    private final Main game;
    private final Texture menuBackground;
    private MenuTab currentMenuTab;
    private int currentMenuItem;
    private Texture[] buildingTextures;
    private Map<MenuTab, VariantProperties[]> buildingVariants;
    private Viewport viewport;
    private boolean flipped;
    private GlyphLayout buildingNameLayout;
    private final Table buildingTable;
    private final Table hotkeyTable;
    private final Table tabTable;
    private final Table tabLabelTable;
    private final Image[] unselectedTabImages = new Image[5];
    private final Image[] selectedTabImages = new Image[5];
    private final Image[] buildingImages = new Image[35];
    public static final Skin SKIN = new Skin(Gdx.files.internal("assets/skins/default/uiskin.json"));

    public BuildingMenu(Main game, Stage stage) {
        int i;
        this.game = game;
        this.viewport = stage.getViewport();
        this.menuBackground = game.getAsset(AssetPaths.MENU_BACKGROUND);
        this.currentMenuTab = MenuTab.ACCOMMODATION;
        this.currentMenuItem = -1;
        this.buildingTextures = new Texture[]{game.getAsset(AssetPaths.ACC1), game.getAsset(AssetPaths.ACC2), game.getAsset(AssetPaths.ACC3), game.getAsset(AssetPaths.ACC4), game.getAsset(AssetPaths.ACC5), game.getAsset(AssetPaths.ROTATE), game.getAsset(AssetPaths.TRASH), game.getAsset(AssetPaths.CATER1), game.getAsset(AssetPaths.CATER2), game.getAsset(AssetPaths.CATER3), game.getAsset(AssetPaths.CATER4), game.getAsset(AssetPaths.CATER5), game.getAsset(AssetPaths.ROTATE), game.getAsset(AssetPaths.TRASH), game.getAsset(AssetPaths.TEACH1), game.getAsset(AssetPaths.TEACH2), game.getAsset(AssetPaths.TEACH3), game.getAsset(AssetPaths.TEACH4), game.getAsset(AssetPaths.TEACH5), game.getAsset(AssetPaths.ROTATE), game.getAsset(AssetPaths.TRASH), game.getAsset(AssetPaths.REC1), game.getAsset(AssetPaths.REC2), game.getAsset(AssetPaths.TREE1), game.getAsset(AssetPaths.TREE2), game.getAsset(AssetPaths.TREE3), game.getAsset(AssetPaths.ROTATE), game.getAsset(AssetPaths.TRASH), game.getAsset(AssetPaths.BIKE_SHED), game.getAsset(AssetPaths.STRAIGHT_ROAD), game.getAsset(AssetPaths.ROAD_CROSS), game.getAsset(AssetPaths.ROAD_BEND1), game.getAsset(AssetPaths.ROAD_BEND2), game.getAsset(AssetPaths.ROTATE), game.getAsset(AssetPaths.TRASH)};
        this.buildingVariants = new HashMap<MenuTab, VariantProperties[]>();
        this.buildingVariants.put(MenuTab.ACCOMMODATION, AccommodationVariant.values());
        this.buildingVariants.put(MenuTab.CATERING, CateringVariant.values());
        this.buildingVariants.put(MenuTab.TEACHING, TeachingVariant.values());
        VariantProperties[] jointTabVariants = new VariantProperties[5];
        System.arraycopy(RecreationVariant.values(), 0, jointTabVariants, 0, 2);
        System.arraycopy(MiscellaneousVariant.values(), 0, jointTabVariants, 2, 3);
        this.buildingVariants.put(MenuTab.RECREATION, jointTabVariants);
        jointTabVariants = new VariantProperties[5];
        System.arraycopy(MiscellaneousVariant.values(), 3, jointTabVariants, 0, 5);
        this.buildingVariants.put(MenuTab.MISCELLANEOUS, jointTabVariants);
        this.tabTable = new Table();
        for (i = 0; i < 5; ++i) {
            this.flipped = false;
            this.unselectedTabImages[i] = new Image(game.getAsset(AssetPaths.MENU_UNSELECTED_TAB));
            this.selectedTabImages[i] = new Image(game.getAsset(AssetPaths.MENU_SELECTED_TAB));
            this.tabTable.add(i == 0 ? this.selectedTabImages[0] : this.unselectedTabImages[i]);
        }
        this.buildingTable = new Table();
        for (i = 0; i < 35; ++i) {
            this.buildingImages[i] = new Image(this.buildingTextures[i]);
            final int buildingIndex = i % 7;
            this.buildingImages[i].addListener(new ClickListener(this){
                final /* synthetic */ BuildingMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void clicked(InputEvent e, float x, float y) {
                    if (buildingIndex == 5) {
                        this.this$0.flipBuildings();
                    } else if (buildingIndex == this.this$0.currentMenuItem) {
                        this.this$0.setCurrentMenuItem(-1);
                    } else {
                        this.this$0.setCurrentMenuItem(buildingIndex);
                    }
                }
            });
        }
        for (i = 0; i < 7; ++i) {
            this.buildingTable.add(this.buildingImages[i]);
        }
        this.tabLabelTable = new Table();
        this.tabLabelTable.add(new Label((CharSequence)"     Accommodation", SKIN));
        this.tabLabelTable.add(new Label((CharSequence)"           Catering", SKIN));
        this.tabLabelTable.add(new Label((CharSequence)"           Teaching", SKIN));
        this.tabLabelTable.add(new Label((CharSequence)"   Recreation & Trees", SKIN));
        this.tabLabelTable.add(new Label((CharSequence)"       Miscelaneous", SKIN));
        i = 0;
        for (Cell cell : this.tabLabelTable.getCells()) {
            final int tab = i++;
            ((Actor)cell.getActor()).addListener(new ClickListener(this){
                final /* synthetic */ BuildingMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void clicked(InputEvent e, float x, float y) {
                    if (this.this$0.currentMenuTab.toInt() != tab) {
                        this.this$0.setCurrentMenuItem(-1);
                        this.this$0.updateTab(tab);
                    }
                }
            });
        }
        this.hotkeyTable = new Table();
        for (i = 1; i < 6; ++i) {
            this.hotkeyTable.add(new Label((CharSequence)("         " + Integer.toString(i)), SKIN));
        }
        this.hotkeyTable.add(new Label((CharSequence)"         R", SKIN));
        this.hotkeyTable.add(new Label((CharSequence)"         D", SKIN));
        stage.addActor(this.tabTable);
        stage.addActor(this.tabLabelTable);
        stage.addActor(this.buildingTable);
        stage.addActor(this.hotkeyTable);
    }

    public void render() {
        this.game.spritebatch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.viewport.apply();
        this.game.spritebatch.begin();
        float menuHeight = (float)this.viewport.getScreenHeight() * 0.15f;
        this.game.spritebatch.draw(this.menuBackground, 0.0f, 0.0f, (float)this.viewport.getScreenWidth(), menuHeight, 0, 0, 1, this.menuBackground.getHeight(), false, false);
        if (this.currentMenuItem >= 0 && this.currentMenuItem < 6) {
            this.buildingNameLayout = new GlyphLayout(this.game.font, this.setCurrentMenuItem(this.currentMenuItem));
            this.game.font.draw((Batch)this.game.spritebatch, this.buildingNameLayout, (float)this.viewport.getScreenWidth() * 0.5f - this.buildingNameLayout.width * 0.5f, menuHeight + this.game.font.getLineHeight());
        }
        this.game.spritebatch.end();
    }

    public void resize(int width, int height) {
        this.buildingTable.setBounds(0.0f, (float)height * 0.01f, width, (float)height * 0.11f);
        this.hotkeyTable.setBounds(0.0f, 0.0f, width, (float)height * 0.03f);
        this.tabTable.setBounds(0.0f, (float)height * 0.08f, width, (float)height * 0.1015f);
        this.tabLabelTable.setBounds(0.0f, (float)height * 0.08f, width, (float)height * 0.1015f);
        this.updateCellSizes();
        this.updateBuildingRotations();
    }

    public void updateTab(int tabNumber) {
        switch (tabNumber) {
            case 0: {
                this.currentMenuTab = MenuTab.ACCOMMODATION;
                break;
            }
            case 1: {
                this.currentMenuTab = MenuTab.CATERING;
                break;
            }
            case 2: {
                this.currentMenuTab = MenuTab.TEACHING;
                break;
            }
            case 3: {
                this.currentMenuTab = MenuTab.RECREATION;
                break;
            }
            case 4: {
                this.currentMenuTab = MenuTab.MISCELLANEOUS;
                break;
            }
            default: {
                throw new UnreachableException("Unreachable state - menu tab not recognised");
            }
        }
        int i = 0;
        for (Cell cell : this.tabTable.getCells()) {
            cell.setActor(i == tabNumber ? this.selectedTabImages[i] : this.unselectedTabImages[i]);
            ++i;
        }
        i = 0;
        for (Cell cell : this.buildingTable.getCells()) {
            cell.setActor(this.buildingImages[7 * tabNumber + i]);
            ++i;
        }
        this.updateSelectedBuildingHighlight();
        this.updateCellSizes();
        this.flipped = false;
        this.updateBuildingRotations();
    }

    private void updateCellSizes() {
        int cellNum = 0;
        for (Cell cell : this.buildingTable.getCells()) {
            Image buildingImage = (Image)cell.getActor();
            Vector2 textureSize = new Vector2(buildingImage.getWidth(), buildingImage.getHeight());
            cell.width((float)this.viewport.getScreenHeight() * 0.1f * (textureSize.x < textureSize.y ? textureSize.x / textureSize.y : 1.0f)).height((float)this.viewport.getScreenHeight() * 0.1f * (textureSize.y < textureSize.x ? textureSize.y / textureSize.x : 1.0f)).pad((float)this.viewport.getScreenHeight() * 0.01f);
            int i = 0;
            for (Cell labelCell : this.hotkeyTable.getCells()) {
                if (i == cellNum) {
                    labelCell.width((float)this.viewport.getScreenHeight() * 0.1f * (textureSize.x < textureSize.y ? textureSize.x / textureSize.y : 1.0f)).height((float)this.viewport.getScreenHeight() * 0.035f).pad((float)this.viewport.getScreenHeight() * 0.01f);
                    ((Label)labelCell.getActor()).setFontScale((float)this.viewport.getScreenHeight() * 0.001f);
                }
                ++i;
            }
            ++cellNum;
        }
        for (Cell cell : this.tabTable.getCells()) {
            cell.width((float)this.viewport.getScreenHeight() * 0.025f * 6.667f).height((float)this.viewport.getScreenHeight() * 0.025f);
        }
        for (Cell cell : this.tabLabelTable.getCells()) {
            cell.width((float)this.viewport.getScreenHeight() * 0.025f * 6.667f).height((float)this.viewport.getScreenHeight() * 0.025f);
            ((Label)cell.getActor()).setFontScale((float)this.viewport.getScreenHeight() * 0.00105f);
        }
    }

    public void updateSelectedBuildingHighlight() {
        int i = 0;
        for (Cell cell : this.buildingTable.getCells()) {
            Image buildingImage = (Image)cell.getActor();
            buildingImage.setColor(1.0f, 1.0f, 1.0f, i == this.currentMenuItem ? 0.2f : 1.0f);
            ++i;
        }
    }

    public String setCurrentMenuItem(int itemNum) {
        this.currentMenuItem = itemNum;
        this.updateSelectedBuildingHighlight();
        if (itemNum >= 0 && itemNum < 5) {
            VariantProperties selectedVariant = this.buildingVariants.get((Object)this.currentMenuTab)[this.currentMenuItem];
            return selectedVariant.getName();
        }
        if (itemNum == 6) {
            return "item delete";
        }
        return "None selected";
    }

    public int getScreenHeight() {
        return (int)((float)this.viewport.getScreenHeight() * 0.15f);
    }

    private void updateBuildingRotations() {
        for (Cell cell : this.buildingTable.getCells()) {
            Image buildingImage = (Image)cell.getActor();
            buildingImage.setOrigin(buildingImage.getWidth() / 2.0f, buildingImage.getHeight() / 2.0f);
            buildingImage.setScaleX(this.flipped ? -1.0f : 1.0f);
            if (buildingImage != this.buildingImages[32]) continue;
            buildingImage.setScaleY(this.flipped ? -1.0f : 1.0f);
        }
    }

    public void flipBuildings() {
        this.flipped = !this.flipped;
        this.updateBuildingRotations();
    }

    public void removeActors() {
        this.buildingTable.remove();
        this.hotkeyTable.remove();
        this.tabTable.remove();
        this.tabLabelTable.remove();
    }

    @Generated
    public MenuTab getCurrentMenuTab() {
        return this.currentMenuTab;
    }

    @Generated
    public int getCurrentMenuItem() {
        return this.currentMenuItem;
    }

    @Generated
    public Texture[] getBuildingTextures() {
        return this.buildingTextures;
    }

    @Generated
    public Map<MenuTab, VariantProperties[]> getBuildingVariants() {
        return this.buildingVariants;
    }

    @Generated
    public Viewport getViewport() {
        return this.viewport;
    }

    @Generated
    public boolean isFlipped() {
        return this.flipped;
    }
}

