/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

public class Camera {
    public float x;
    public float y;
    public int width;
    public int height;
    public float vx;
    public float vy;
    public float zoomV;
    public float scale;
    private float time;
    private final float timeStepSize = 0.001f;

    public Camera(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.vx = 0.0f;
        this.vy = 0.0f;
        this.zoomV = 0.0f;
        this.scale = 1080.0f / (float)height;
    }

    public void shift() {
        this.x += (float)((int)(this.vx * this.scale));
        this.y += (float)((int)(this.vy * this.scale));
    }

    public void addVelocity(float vx, float vy) {
        this.vx += vx;
        this.vy += vy;
    }

    public void velocityReset() {
        this.vx = 0.0f;
        this.vy = 0.0f;
    }

    public void resize(int width, int height) {
        this.x += (float)this.width * this.scale / 2.0f;
        this.y += (float)this.height * this.scale / 2.0f;
        this.scale *= (float)this.height / (float)height;
        this.width = width;
        this.height = height;
        this.x -= (float)this.width * this.scale / 2.0f;
        this.y -= (float)this.height * this.scale / 2.0f;
    }

    public void zoom(float factor) {
        this.x += (float)this.width * this.scale / 2.0f;
        this.y += (float)this.height * this.scale / 2.0f;
        this.scale *= factor;
        if (this.scale > 3500.0f / (float)this.height) {
            this.scale = 3500.0f / (float)this.height;
        } else if (this.scale < 500.0f / (float)this.height) {
            this.scale = 500.0f / (float)this.height;
        }
        this.x -= (float)this.width * this.scale / 2.0f;
        this.y -= (float)this.height * this.scale / 2.0f;
    }

    public void updateZoom(float delta) {
        this.time += delta;
        while (this.time > 0.0f) {
            this.zoomV *= 0.99f;
            this.zoom(1.0f + this.zoomV);
            this.time -= 0.001f;
        }
    }

    public void pan(int x, int y) {
        this.x += (float)x * this.scale;
        this.y += (float)y * this.scale;
    }
}

