/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.viewport.Viewport;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.GameState;
import y111studios.Main;
import y111studios.score.ScoreManager;
import y111studios.screens.StartScreen;
import y111studios.screens.leaderboard.LeaderboardScore;

public class GameOverMenu {
    private final Main game;
    private final GameState gameState;
    private final Texture menuBackground;
    private Viewport viewport;
    private Table titleTable;
    private Table mainTable;
    private TextField nameInput;
    private Cell<Actor> nameInputCell;
    private TextButton backButton;
    private Cell<Actor> backButtonCell;
    public static final Skin SKIN = new Skin(Gdx.files.internal("assets/skins/default/uiskin.json"));

    public GameOverMenu(final GameState gameState, final Main game, Stage stage) {
        this.game = game;
        this.gameState = gameState;
        this.viewport = stage.getViewport();
        this.menuBackground = game.getAsset(AssetPaths.MENU_BACKGROUND);
        ScoreManager scoreManager = gameState.getScoreManager();
        final int score = scoreManager.calculateScore();
        this.titleTable = new Table();
        this.titleTable.add(new Label((CharSequence)("Game Over - Score: " + score), SKIN));
        this.mainTable = new Table();
        this.nameInput = new TextField("", SKIN);
        this.nameInput.setMessageText("Name");
        this.nameInputCell = this.mainTable.add(this.nameInput);
        this.mainTable.row();
        this.backButton = new TextButton("Save Score and go Home", SKIN);
        this.backButton.addListener(new ClickListener(this){
            final /* synthetic */ GameOverMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                String name = this.this$0.nameInput.getText();
                name = name == "" ? "Unnamed Player" : name;
                game.leaderboard.insertScore(new LeaderboardScore(name, score));
                game.leaderboard.saveJson();
                gameState.setScreen(new StartScreen(game));
            }
        });
        this.backButtonCell = this.mainTable.add(this.backButton);
        stage.addActor(this.titleTable);
        stage.addActor(this.mainTable);
        this.resize(stage.getViewport().getScreenWidth(), stage.getViewport().getScreenHeight());
    }

    public void render() {
        this.game.spritebatch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.viewport.apply();
        this.game.spritebatch.begin();
        float menuHeight = (float)this.viewport.getScreenHeight() * 0.15f;
        this.game.spritebatch.draw(this.menuBackground, 0.0f, 0.0f, (float)this.viewport.getScreenWidth(), menuHeight, 0, 0, 1, this.menuBackground.getHeight(), false, false);
        this.game.spritebatch.end();
    }

    public void resize(int width, int height) {
        this.titleTable.setBounds(0.0f, (float)height * 0.08f, width, (float)height * 0.11f);
        for (Cell cell : this.titleTable.getCells()) {
            ((Label)cell.getActor()).setFontScale((float)this.viewport.getScreenHeight() * 0.0016f);
        }
        this.mainTable.setBounds(0.0f, 0.0f, width, (float)height * 0.08f);
        this.nameInputCell.height((float)height * 0.03f).width((float)height * 0.24f);
        this.backButtonCell.pad((float)height * 0.02f);
        ((TextButton)this.backButtonCell.getActor()).getLabel().setFontScale((float)this.viewport.getScreenHeight() * 0.0013f);
    }

    public int getScreenHeight() {
        return (int)((float)this.viewport.getScreenHeight() * 0.15f);
    }

    @Generated
    public Viewport getViewport() {
        return this.viewport;
    }
}

