/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.Screen;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import lombok.Generated;
import y111studios.Camera;
import y111studios.Main;
import y111studios.StudentSatisfaction;
import y111studios.buildings.Building;
import y111studios.buildings.BuildingController;
import y111studios.buildings.BuildingManager;
import y111studios.buildings.ObstacleBuilding;
import y111studios.clock.Clock;
import y111studios.clock.GameTimer;
import y111studios.events.Event;
import y111studios.events.FloodEvent;
import y111studios.events.OpenDayEvent;
import y111studios.events.PandemicEvent;
import y111studios.events.ResearchBreakthroughEvent;
import y111studios.events.SnowEvent;
import y111studios.map.CollisionDetection;
import y111studios.position.GridPosition;
import y111studios.score.ScoreManager;

public class GameState
implements GameTimer,
BuildingController {
    private static final int NUM_EVENT_TYPES = 4;
    private GameTimer timer;
    private Main game;
    public BuildingManager buildingManager;
    CollisionDetection collisionDetection;
    private StudentSatisfaction studentSatisfaction;
    private ScoreManager scoreManager;
    private Event currentEvent;
    private long lastTickTime;
    private Camera camera;
    private int numTicks;
    private ArrayList<Integer> unplayedEvents;

    public GameState(int width, int height, Main game) {
        this.game = game;
        this.timer = new Clock();
        this.lastTickTime = 0L;
        this.buildingManager = new BuildingManager();
        this.numTicks = 0;
        int[][] staticObjects = new int[][]{{42, 12, 16, 16}, {46, 10, 11, 2}, {52, 15, 4, 13}, {46, 28, 6, 1}, {48, 29, 2, 1}, {41, 13, 1, 11}, {40, 17, 1, 2}, {56, 18, 2, 15}, {31, 32, 26, 2}, {30, 33, 2, 19}, {27, 52, 4, 2}, {26, 53, 2, 7}, {19, 60, 7, 2}, {15, 59, 4, 4}, {15, 15, 7, 8}, {18, 23, 3, 1}, {14, 17, 1, 5}, {17, 14, 6, 7}, {11, 35, 10, 14}, {21, 35, 2, 8}, {55, 49, 8, 12}, {32, 43, 1, 3}};
        this.collisionDetection = new CollisionDetection(width, height, staticObjects);
        this.studentSatisfaction = new StudentSatisfaction(this.buildingManager, staticObjects);
        this.scoreManager = new ScoreManager();
        this.unplayedEvents = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            this.unplayedEvents.add(i);
        }
        this.currentEvent = null;
    }

    @Override
    public Building getBuilding(GridPosition position) {
        if (position == null) {
            return null;
        }
        if (this.collisionDetection.canPlaceBuilding(position)) {
            return null;
        }
        return this.buildingManager.getBuilding(position);
    }

    @Override
    public boolean push(Building building) {
        if (building == null) {
            return true;
        }
        if (this.buildingManager.isFull()) {
            return false;
        }
        if (!this.collisionDetection.placeBuilding(building.getArea())) {
            return false;
        }
        this.buildingManager.push(building);
        return true;
    }

    @Override
    public boolean removePosition(GridPosition position) {
        if (position == null) {
            return false;
        }
        Building building = this.buildingManager.getBuilding(position);
        if (building == null || building instanceof ObstacleBuilding) {
            return false;
        }
        this.collisionDetection.removeBuilding(building.getArea());
        this.buildingManager.removePosition(position);
        return true;
    }

    @Override
    public int getCount() {
        return this.buildingManager.getCount();
    }

    @Override
    public boolean isFull() {
        return this.buildingManager.isFull();
    }

    @Override
    public boolean isPaused() {
        return this.timer.isPaused();
    }

    @Override
    public void pause() {
        this.timer.pause();
    }

    @Override
    public void resume() {
        this.timer.resume();
    }

    @Override
    public boolean isTimeUp() {
        return this.timer.isTimeUp();
    }

    @Override
    public Duration timeRemaining() {
        return this.timer.timeRemaining();
    }

    public boolean canPlaceBuilding(Building building) {
        return this.collisionDetection.canPlaceBuilding(building.getArea());
    }

    public void setScreen(Screen screen) {
        this.game.setScreen(screen);
    }

    public Main getGame() {
        return this.game;
    }

    public void tick() {
        if (!this.timer.isPaused()) {
            if (this.lastTickTime == 0L) {
                this.lastTickTime = System.currentTimeMillis();
                return;
            }
            long currentTimeRemaining = System.currentTimeMillis();
            long numTicksToSimulate = (currentTimeRemaining - this.lastTickTime) / 16L;
            long remainder = (currentTimeRemaining - this.lastTickTime) % 16L;
            this.lastTickTime = currentTimeRemaining - remainder;
            while (numTicksToSimulate-- > 0L) {
                this.studentSatisfaction.tick();
                this.buildingManager.tick();
                this.scoreManager.tick(this.studentSatisfaction.getSatisfaction());
                if (this.numTicks % 3720 == 0 && this.numTicks > 0) {
                    if (this.numTicks > 14880) {
                        this.currentEvent = null;
                    } else if (this.numTicks == 14880) {
                        this.currentEvent = new OpenDayEvent(this.game, this);
                    } else {
                        int eventIndex = new Random().nextInt(this.unplayedEvents.size());
                        int eventNum = this.unplayedEvents.get(eventIndex);
                        this.unplayedEvents.remove(eventIndex);
                        switch (eventNum) {
                            case 0: {
                                this.currentEvent = new FloodEvent(this.game, this, this.camera);
                                break;
                            }
                            case 1: {
                                this.currentEvent = new SnowEvent(this.game, this, this.camera);
                                break;
                            }
                            case 2: {
                                this.currentEvent = new ResearchBreakthroughEvent(this.game, this);
                                break;
                            }
                            case 3: {
                                this.currentEvent = new PandemicEvent(this.game, this);
                                break;
                            }
                        }
                    }
                    this.studentSatisfaction.setCurrentEvent(this.currentEvent);
                    if (this.currentEvent != null) {
                        this.currentEvent.setNotification();
                    }
                }
                ++this.numTicks;
            }
            if (this.timer.isTimeUp()) {
                this.timer.pause();
            }
        } else {
            this.lastTickTime = 0L;
        }
    }

    @Generated
    public GameTimer getTimer() {
        return this.timer;
    }

    @Generated
    public StudentSatisfaction getStudentSatisfaction() {
        return this.studentSatisfaction;
    }

    @Generated
    public ScoreManager getScoreManager() {
        return this.scoreManager;
    }

    @Generated
    public void setCurrentEvent(Event currentEvent) {
        this.currentEvent = currentEvent;
    }

    @Generated
    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    @Generated
    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    @Generated
    public int getNumTicks() {
        return this.numTicks;
    }
}

