/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.GameState;
import y111studios.Main;
import y111studios.buildings.BuildingCounter;
import y111studios.buildings.BuildingType;
import y111studios.events.FloodEvent;
import y111studios.events.OpenDayEvent;
import y111studios.events.PandemicEvent;
import y111studios.events.ResearchBreakthroughEvent;
import y111studios.events.SnowEvent;

public class InfoBar {
    private final Texture infoBarBackground;
    private final GameState gameState;
    private final Main game;
    private final Stage stage;
    private final Texture muteTexture;
    private final Texture unmuteTexture;
    private Image muteImage;
    private Image unmuteImage;
    private final Texture pauseTexture;
    private final Texture playTexture;
    private Image pauseImage;
    private Image playImage;
    private Table table;
    private Cell muteButtonCell;
    private Cell pauseButtonCell;
    private float infoBarHeight;

    public InfoBar(final GameState gameState, final Main game, Stage stage) {
        this.gameState = gameState;
        this.game = game;
        this.stage = stage;
        this.infoBarBackground = game.getAsset(AssetPaths.INFO_BAR_BACKGROUND);
        this.muteTexture = game.getAsset(AssetPaths.MUTE_BUTTON);
        this.unmuteTexture = game.getAsset(AssetPaths.UNMUTE_BUTTON);
        this.muteImage = new Image(this.muteTexture);
        this.unmuteImage = new Image(this.unmuteTexture);
        this.pauseTexture = game.getAsset(AssetPaths.PAUSE_BUTTON);
        this.playTexture = game.getAsset(AssetPaths.PLAY_BUTTON);
        this.pauseImage = new Image(this.pauseTexture);
        this.playImage = new Image(this.playTexture);
        this.muteImage.addListener(new ClickListener(this){
            final /* synthetic */ InfoBar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                game.backgroundMusic.setVolume(0.3f);
                this.this$0.muteButtonCell.setActor(this.this$0.unmuteImage);
            }
        });
        this.unmuteImage.addListener(new ClickListener(this){
            final /* synthetic */ InfoBar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                game.backgroundMusic.setVolume(0.0f);
                this.this$0.muteButtonCell.setActor(this.this$0.muteImage);
            }
        });
        this.playImage.addListener(new ClickListener(this){
            final /* synthetic */ InfoBar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                gameState.resume();
                this.this$0.pauseButtonCell.setActor(this.this$0.pauseImage);
            }
        });
        this.pauseImage.addListener(new ClickListener(this){
            final /* synthetic */ InfoBar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                gameState.pause();
                this.this$0.pauseButtonCell.setActor(this.this$0.playImage);
            }
        });
        this.table = new Table();
        this.muteButtonCell = this.table.add(game.backgroundMusic.getVolume() == 0.0f ? this.muteImage : this.unmuteImage);
        this.pauseButtonCell = this.table.add(this.playImage);
        stage.addActor(this.table);
    }

    public void render() {
        this.game.spritebatch.begin();
        float screenWidth = this.stage.getViewport().getScreenWidth();
        float screenHeight = this.stage.getViewport().getScreenHeight();
        if (this.gameState.isPaused()) {
            this.pauseButtonCell.setActor(this.playImage);
        } else {
            this.pauseButtonCell.setActor(this.pauseImage);
        }
        this.game.spritebatch.draw(this.infoBarBackground, 0.0f, screenHeight - this.infoBarHeight, screenWidth, this.infoBarHeight, 0, 0, 1, this.infoBarBackground.getHeight(), false, false);
        int buildingCount = this.gameState.getCount();
        String buildingString = String.format("Count: %d / %d", buildingCount, 250);
        this.game.font.draw((Batch)this.game.spritebatch, buildingString, screenHeight * 0.01f, screenHeight * 0.99f);
        BuildingCounter counter = this.gameState.buildingManager.getCounter();
        Map<BuildingType, Integer> buildingCounts = counter.getBuildingMap();
        float drawIndent = screenHeight * 0.01f;
        for (BuildingType type : BuildingType.values()) {
            int count = buildingCounts.get((Object)type);
            String countString = String.format("%c: %d", Character.valueOf(type.toString().toCharArray()[0]), count);
            GlyphLayout countLayout = new GlyphLayout(this.game.font, countString);
            this.game.font.draw((Batch)this.game.spritebatch, countString, drawIndent, screenHeight * 1.01f - this.infoBarHeight + countLayout.height);
            drawIndent += countLayout.width + screenHeight * 0.01f;
        }
        Duration timeRemaining = this.gameState.timeRemaining();
        String timeString = String.format("%02d:%02d", timeRemaining.toMinutesPart(), timeRemaining.toSecondsPart());
        GlyphLayout timeStringLayout = new GlyphLayout(this.game.font, timeString);
        float textWidth = timeStringLayout.width;
        float textHeight = timeStringLayout.height;
        float timeStringX = (screenWidth - textWidth) / 2.0f;
        float timeStringY = screenHeight - (this.infoBarHeight - textHeight) / 2.0f;
        this.game.font.draw((Batch)this.game.spritebatch, timeString, timeStringX, timeStringY);
        double satisfaction = this.gameState.getStudentSatisfaction().getSatisfaction();
        String satisfactionString = String.format("Satisfaction: %.2f", satisfaction) + "%";
        GlyphLayout satisfactionStringLayout = new GlyphLayout(this.game.font, satisfactionString);
        float satisfactionStringWidth = satisfactionStringLayout.width;
        this.game.font.draw((Batch)this.game.spritebatch, satisfactionString, screenWidth - satisfactionStringWidth - 10.0f, screenHeight - (this.infoBarHeight - textHeight) / 2.0f);
        String eventString = this.gameState.getCurrentEvent() instanceof FloodEvent ? "Event: Flood" : (this.gameState.getCurrentEvent() instanceof SnowEvent ? "Event: Snow" : (this.gameState.getCurrentEvent() instanceof ResearchBreakthroughEvent ? "Event: Research Breakthrough" : (this.gameState.getCurrentEvent() instanceof PandemicEvent ? "Event: Pandemic" : (this.gameState.getCurrentEvent() instanceof OpenDayEvent ? "Event: Open Day" : "Event: None"))));
        GlyphLayout eventStringLayout = new GlyphLayout(this.game.font, eventString);
        textWidth = eventStringLayout.width;
        float eventStringX = screenWidth - textWidth - satisfactionStringWidth * 1.3f;
        float eventStringY = screenHeight - (this.infoBarHeight - textHeight) / 2.0f;
        this.game.font.draw((Batch)this.game.spritebatch, eventString, eventStringX, eventStringY);
        this.game.spritebatch.end();
    }

    public void resize(int width, int height) {
        this.infoBarHeight = (float)height * 0.08f;
        this.table.setBounds(0.0f, (float)height - this.infoBarHeight, width, this.infoBarHeight);
        this.muteButtonCell.width(this.infoBarHeight * 0.6f).height(this.infoBarHeight * 0.6f).padLeft((float)height * 0.35f);
        this.pauseButtonCell.width(this.infoBarHeight * 0.6f).height(this.infoBarHeight * 0.6f).padLeft((float)height * 0.02f).padRight((float)width * 0.65f);
    }

    @Generated
    public float getInfoBarHeight() {
        return this.infoBarHeight;
    }
}

