/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import y111studios.AssetLibrary;
import y111studios.AssetPaths;
import y111studios.UniversalInputProcessor;
import y111studios.screens.StartScreen;
import y111studios.screens.leaderboard.Leaderboard;

public class Main
extends Game {
    public AssetLibrary assetLib;
    public SpriteBatch spritebatch;
    public BitmapFont font;
    public Music backgroundMusic;
    public UniversalInputProcessor universalInputProcessor = new UniversalInputProcessor();
    public Leaderboard leaderboard;

    @Override
    public void create() {
        this.assetLib = AssetLibrary.getInstance();
        this.assetLib.init();
        this.spritebatch = new SpriteBatch();
        this.font = new BitmapFont();
        this.font.setColor(Color.BLACK);
        Gdx.graphics.setWindowedMode(1280, 720);
        this.setScreen(new StartScreen(this));
        Audio audio = Gdx.audio;
        this.backgroundMusic = audio.newMusic(Gdx.files.internal("assets/retro-8bit-happy-videogame-music-243998.mp3"));
        this.backgroundMusic.setVolume(0.3f);
        this.backgroundMusic.setLooping(true);
        this.backgroundMusic.play();
        this.leaderboard = new Leaderboard(true);
    }

    public Texture getAsset(AssetPaths path) {
        return (Texture)this.assetLib.manager.get(path.getPath());
    }

    @Override
    public void resize(int width, int height) {
        if (width + height > 0) {
            this.font.getData().setScale((float)height * 0.00165f);
            super.resize(width, height);
            this.universalInputProcessor.resize(width, height);
        }
    }

    @Override
    public void dispose() {
        this.spritebatch.dispose();
        this.font.dispose();
        this.assetLib.manager.dispose();
        this.backgroundMusic.dispose();
    }
}

