/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.buildings.Building;
import y111studios.buildings.BuildingManager;
import y111studios.buildings.BuildingType;
import y111studios.buildings.premade_variants.AccommodationVariant;
import y111studios.buildings.premade_variants.CateringVariant;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.RecreationVariant;
import y111studios.buildings.premade_variants.TeachingVariant;
import y111studios.events.Event;
import y111studios.events.FloodEvent;
import y111studios.events.PandemicEvent;
import y111studios.events.ResearchBreakthroughEvent;
import y111studios.events.SnowEvent;

public class StudentSatisfaction {
    private final BuildingManager buildingManager;
    private double satisfaction;
    private int[][] natureAreas;
    private Event currentEvent;

    public StudentSatisfaction(BuildingManager buildingManager, int[][] natureAreas) {
        this.buildingManager = buildingManager;
        this.satisfaction = 0.0;
        this.natureAreas = natureAreas;
    }

    public void tick() {
        double satisfactionLimit = this.calculate();
        this.satisfaction = this.satisfaction * 0.997 + satisfactionLimit * 0.003;
    }

    public double calculate() {
        HashMap<BuildingType, Integer> buildingCounts = new HashMap<BuildingType, Integer>();
        buildingCounts.put(BuildingType.ACCOMMODATION, 0);
        buildingCounts.put(BuildingType.CATERING, 0);
        buildingCounts.put(BuildingType.TEACHING, 0);
        buildingCounts.put(BuildingType.RECREATION, 0);
        double satisfaction = 100.0;
        int numRoads = 0;
        int buildingRotationTotal = 0;
        double totalRoadFlow = 0.0;
        HashSet<AssetPaths> buildingVariants = new HashSet<AssetPaths>();
        for (Building building : this.buildingManager.getBuildings()) {
            if (building == null || building.getAge() < 1200) continue;
            if (building.getVariant() instanceof AccommodationVariant) {
                buildingCounts.put(BuildingType.ACCOMMODATION, (Integer)buildingCounts.get((Object)BuildingType.ACCOMMODATION) + 1);
            } else if (building.getVariant() instanceof CateringVariant) {
                buildingCounts.put(BuildingType.CATERING, (Integer)buildingCounts.get((Object)BuildingType.CATERING) + 1);
            } else if (building.getVariant() instanceof TeachingVariant) {
                buildingCounts.put(BuildingType.TEACHING, (Integer)buildingCounts.get((Object)BuildingType.TEACHING) + 1);
            } else if (building.getVariant() instanceof RecreationVariant) {
                buildingCounts.put(BuildingType.RECREATION, (Integer)buildingCounts.get((Object)BuildingType.RECREATION) + 1);
            }
            buildingVariants.add(building.getTexturePath());
            buildingRotationTotal += building.getFlipped() ? 1 : -1;
            double accommodationDistance = 2.147483647E9;
            double cateringDistance = 2.147483647E9;
            double teachingDistance = 2.147483647E9;
            double recreationDistance = 2.147483647E9;
            double roadDistance = 2.147483647E9;
            double roadFlow = 0.0;
            double natureBonus = 0.0;
            natureBonus = 0.0;
            roadFlow = 0.0;
            boolean isRoad = false;
            for (Building otherBuilding : this.buildingManager.getBuildings()) {
                if (otherBuilding == null || otherBuilding == building || otherBuilding.getAge() < 1200) continue;
                double distance = this.getSquaredDistance(building, otherBuilding);
                if (otherBuilding.getVariant() instanceof AccommodationVariant) {
                    accommodationDistance = Math.min(accommodationDistance, distance);
                    continue;
                }
                if (otherBuilding.getVariant() instanceof CateringVariant) {
                    cateringDistance = Math.min(cateringDistance, distance);
                    continue;
                }
                if (otherBuilding.getVariant() instanceof TeachingVariant) {
                    teachingDistance = Math.min(teachingDistance, distance);
                    continue;
                }
                if (otherBuilding.getVariant() instanceof RecreationVariant) {
                    recreationDistance = Math.min(recreationDistance, distance);
                    continue;
                }
                if (otherBuilding.getVariant() == MiscellaneousVariant.ROAD_BEND1 || otherBuilding.getVariant() == MiscellaneousVariant.ROAD_BEND2 || otherBuilding.getVariant() == MiscellaneousVariant.ROAD_CROSS || otherBuilding.getVariant() == MiscellaneousVariant.STRAIGHT_ROAD) {
                    roadDistance = Math.min(roadDistance, distance);
                    if (building.getVariant() != MiscellaneousVariant.ROAD_BEND1 && building.getVariant() != MiscellaneousVariant.ROAD_BEND2 && building.getVariant() != MiscellaneousVariant.ROAD_CROSS && building.getVariant() != MiscellaneousVariant.STRAIGHT_ROAD) continue;
                    isRoad = true;
                    if (!(Math.abs(distance - 4.0) < 0.1)) continue;
                    roadFlow += 0.06;
                    if (building.getVariant() != MiscellaneousVariant.STRAIGHT_ROAD || otherBuilding.getVariant() != MiscellaneousVariant.STRAIGHT_ROAD || building.getFlipped() != otherBuilding.getFlipped()) continue;
                    roadFlow += 0.06;
                    continue;
                }
                if (otherBuilding.getVariant() != MiscellaneousVariant.TREE1 && otherBuilding.getVariant() != MiscellaneousVariant.TREE2 && otherBuilding.getVariant() != MiscellaneousVariant.TREE3) continue;
                natureBonus += 0.3 / distance;
            }
            boolean inNatureRegion = false;
            for (int i = 0; i < this.natureAreas.length; ++i) {
                boolean buildingIntersectsArea;
                int border = 4;
                boolean bl = buildingIntersectsArea = building.getArea().getOrigin().getX() <= this.natureAreas[i][0] + this.natureAreas[i][2] + 4 && building.getArea().getOrigin().getX() + building.getArea().getWidth() >= this.natureAreas[i][0] - 4 && building.getArea().getOrigin().getY() <= this.natureAreas[i][1] + this.natureAreas[i][3] + 4 && building.getArea().getOrigin().getY() + building.getArea().getHeight() >= this.natureAreas[i][1] - 4;
                if (!buildingIntersectsArea) continue;
                inNatureRegion = true;
                break;
            }
            if (inNatureRegion) {
                natureBonus += 0.1;
            }
            natureBonus = Math.min(natureBonus, 0.2);
            if (this.currentEvent instanceof FloodEvent) {
                natureBonus *= 2.0;
            } else if (this.currentEvent instanceof PandemicEvent) {
                natureBonus *= 3.0;
            }
            if (building.getVariant() instanceof AccommodationVariant) {
                int numAccommodationBuildings = this.buildingManager.getCounter().getBuildingMap().get((Object)BuildingType.ACCOMMODATION);
                satisfaction /= 1.0 + Math.pow(teachingDistance, 0.25) * 0.01 / (double)numAccommodationBuildings;
                satisfaction /= 1.0 + Math.pow(cateringDistance, 0.25) * 0.01 / (double)numAccommodationBuildings;
                satisfaction /= 1.0 + Math.pow(recreationDistance, 0.25) * 0.01 / (double)numAccommodationBuildings;
                satisfaction /= 1.0 + Math.pow(roadDistance, 0.25) * 0.03 / (double)numAccommodationBuildings;
                satisfaction = satisfaction * (1.0 - (natureBonus /= (double)numAccommodationBuildings)) + 100.0 * natureBonus;
            }
            if (building.getVariant() instanceof TeachingVariant) {
                int numTeachingBuildings = this.buildingManager.getCounter().getBuildingMap().get((Object)BuildingType.TEACHING);
                satisfaction /= 1.0 + Math.pow(cateringDistance, 0.25) * 0.005 / (double)numTeachingBuildings;
                satisfaction /= 1.0 + Math.pow(recreationDistance, 0.25) * 0.01 / (double)numTeachingBuildings;
                satisfaction /= 1.0 + Math.pow(roadDistance, 0.25) * 0.03 / (double)numTeachingBuildings;
                satisfaction = satisfaction * (1.0 - (natureBonus /= (double)numTeachingBuildings)) + 100.0 * natureBonus;
            }
            if (building.getVariant() instanceof RecreationVariant) {
                int numRecreationBuildlings = this.buildingManager.getCounter().getBuildingMap().get((Object)BuildingType.RECREATION);
                satisfaction /= 1.0 + Math.pow(cateringDistance, 0.25) * 0.005 / (double)numRecreationBuildlings;
                satisfaction /= 1.0 + Math.pow(roadDistance, 0.25) * 0.03 / (double)numRecreationBuildlings;
            }
            if (building.getVariant() instanceof CateringVariant) {
                int numCateringBuidlings = this.buildingManager.getCounter().getBuildingMap().get((Object)BuildingType.CATERING);
                satisfaction /= 1.0 + Math.pow(roadDistance, 0.25) * 0.03 / (double)numCateringBuidlings;
            }
            numRoads += isRoad ? 1 : 0;
            totalRoadFlow += Math.min(roadFlow, 0.12);
        }
        if ((Integer)buildingCounts.get((Object)BuildingType.ACCOMMODATION) == 0 || (Integer)buildingCounts.get((Object)BuildingType.CATERING) == 0) {
            return 0.0;
        }
        double teachingRatio = (double)((Integer)buildingCounts.get((Object)BuildingType.TEACHING)).intValue() / (double)((Integer)buildingCounts.get((Object)BuildingType.ACCOMMODATION)).intValue();
        double cateringRatio = (double)((Integer)buildingCounts.get((Object)BuildingType.CATERING)).intValue() / (double)((Integer)buildingCounts.get((Object)BuildingType.ACCOMMODATION)).intValue();
        double recreationalRatio = (double)((Integer)buildingCounts.get((Object)BuildingType.RECREATION)).intValue() / (double)((Integer)buildingCounts.get((Object)BuildingType.ACCOMMODATION)).intValue();
        satisfaction /= 1.0 + Math.abs(teachingRatio - 0.3);
        satisfaction /= 1.0 + Math.max(0.2 - cateringRatio, 0.0);
        satisfaction /= 1.0 + Math.max(0.2 - recreationalRatio, 0.0);
        satisfaction = satisfaction * (1.0 - (double)buildingVariants.size() / 250.0) + 100.0 * (double)buildingVariants.size() / 250.0;
        satisfaction /= 1.0 + (double)Math.abs(buildingRotationTotal) / 300.0;
        double averageRoadFlow = Math.min(totalRoadFlow / (double)Math.max(numRoads, 1), 0.12);
        satisfaction = satisfaction * (1.0 - averageRoadFlow) + 100.0 * averageRoadFlow;
        if (this.currentEvent instanceof SnowEvent) {
            satisfaction = satisfaction * 0.75 + 25.0;
        } else if (this.currentEvent instanceof ResearchBreakthroughEvent) {
            satisfaction = satisfaction * 0.95 + 5.0;
        } else if (this.currentEvent instanceof PandemicEvent) {
            satisfaction *= 0.6;
        } else if (this.currentEvent instanceof FloodEvent) {
            satisfaction *= 0.7;
        }
        return satisfaction;
    }

    private double getSquaredDistance(Building building1, Building building2) {
        int distX = building1.getArea().getOrigin().getX() + building1.getArea().getWidth() / 2 - building2.getArea().getOrigin().getX() - building2.getArea().getWidth() / 2;
        int distY = building1.getArea().getOrigin().getY() + building1.getArea().getHeight() / 2 - building2.getArea().getOrigin().getY() - building2.getArea().getHeight() / 2;
        return distX * distX + distY * distY;
    }

    @Generated
    public void setSatisfaction(double satisfaction) {
        this.satisfaction = satisfaction;
    }

    @Generated
    public double getSatisfaction() {
        return this.satisfaction;
    }

    @Generated
    public void setCurrentEvent(Event currentEvent) {
        this.currentEvent = currentEvent;
    }
}

