/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.Camera;
import y111studios.GameState;
import y111studios.Main;
import y111studios.buildings.Building;
import y111studios.buildings.BuildingFactory;
import y111studios.buildings.ObstacleBuilding;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.ObstacleVariant;
import y111studios.buildings.premade_variants.VariantProperties;
import y111studios.events.FloodEvent;
import y111studios.events.SnowEvent;
import y111studios.position.GridPosition;
import y111studios.screens.MapScreen;
import y111studios.utils.UnreachableException;

public class World {
    private int width = 1;
    private int height = 1;
    public static final int TILE_WIDTH = 75;
    public static final int TILE_HEIGHT = 75;
    private static final Color NOT_BUILT = new Color(1.0f, 0.898f, 0.0f, 0.55f);
    private static final Color TRANSPARENT_PREVIEW = new Color(1.0f, 1.0f, 1.0f, 0.475f);
    private static final Color INVALID_PREVIEW = new Color(1.0f, 0.5f, 0.5f, 0.475f);
    private static final Color NORMAL = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final Main game;
    private GameState gameState;
    private final Texture[] gameMap = new Texture[4];
    private final Texture[] snowyMap = new Texture[4];
    private final Texture[] floodedMap = new Texture[4];
    private Vector3 cursorScreenPos;
    private Camera camera;
    private Building selectedBuilding;
    private List<Building> buildings;
    private Stack<Integer> recentlyPlaced = new Stack();
    private Viewport viewport = new ScreenViewport();
    private boolean deleteMode = false;
    private MapScreen parentScreen;

    public World(Main game, GameState gameState, MapScreen parentScreen) {
        this.game = game;
        this.gameState = gameState;
        this.parentScreen = parentScreen;
        this.buildings = new ArrayList<Building>();
        this.camera = new Camera(2000, 1000, this.width, this.height);
        gameState.setCamera(this.camera);
        if (game != null) {
            this.gameMap[0] = game.getAsset(AssetPaths.MAP_BACKGROUND_TOP_LEFT);
            this.gameMap[1] = game.getAsset(AssetPaths.MAP_BACKGROUND_TOP_RIGHT);
            this.gameMap[2] = game.getAsset(AssetPaths.MAP_BACKGROUND_BOTTOM_LEFT);
            this.gameMap[3] = game.getAsset(AssetPaths.MAP_BACKGROUND_BOTTOM_RIGHT);
            this.snowyMap[0] = game.getAsset(AssetPaths.SNOWY_MAP_BACKGROUD_TOP_LEFT);
            this.snowyMap[1] = game.getAsset(AssetPaths.SNOWY_MAP_BACKGROUD_TOP_RIGHT);
            this.snowyMap[2] = game.getAsset(AssetPaths.SNOWY_MAP_BACKGROUD_BOTTOM_LEFT);
            this.snowyMap[3] = game.getAsset(AssetPaths.SNOWY_MAP_BACKGROUD_BOTTOM_RIGHT);
            this.floodedMap[0] = game.getAsset(AssetPaths.FLOODED_MAP_BACKGROUD_TOP_LEFT);
            this.floodedMap[1] = game.getAsset(AssetPaths.FLOODED_MAP_BACKGROUD_TOP_RIGHT);
            this.floodedMap[2] = game.getAsset(AssetPaths.FLOODED_MAP_BACKGROUD_BOTTOM_LEFT);
            this.floodedMap[3] = game.getAsset(AssetPaths.FLOODED_MAP_BACKGROUD_BOTTOM_RIGHT);
            for (ObstacleVariant variant : ObstacleVariant.values()) {
                this.addObject(variant, variant.getPosition(), false);
            }
        }
    }

    public boolean addObject(VariantProperties variant, GridPosition coords, boolean flipped) {
        Building current;
        int index;
        Building building = variant == MiscellaneousVariant.ROAD_BEND2 && flipped ? BuildingFactory.createBuilding(MiscellaneousVariant.ROAD_BEND2_FLIPPED, coords, flipped) : BuildingFactory.createBuilding(variant, coords, flipped);
        if (!this.gameState.push(building) && !(variant instanceof ObstacleVariant)) {
            return false;
        }
        int buildingHeight = coords.getY() - coords.getX();
        for (index = 0; index < this.buildings.size() && (current = this.buildings.get(index)).getArea().getY() - current.getArea().getX() <= buildingHeight; ++index) {
        }
        this.buildings.add(index, building);
        if (!(variant instanceof ObstacleVariant)) {
            this.recentlyPlaced.add(index);
        }
        if (variant instanceof ObstacleVariant || variant instanceof MiscellaneousVariant) {
            building.setAge(1200);
        }
        return true;
    }

    public boolean removeObject(GridPosition coords) {
        if (!this.gameState.removePosition(coords)) {
            return false;
        }
        for (int i = 0; i < this.buildings.size(); ++i) {
            Building current = this.buildings.get(i);
            if (!current.contains(coords) || current instanceof ObstacleBuilding) continue;
            this.buildings.remove(i);
            return true;
        }
        throw new UnreachableException("State de-synced with renderOrdering");
    }

    public float[] tileToPixel(GridPosition coords) {
        float pixelX = (float)(129 + (coords.getX() + coords.getY()) * 32) - this.camera.x;
        float pixelY = (float)(-1343 + (coords.getX() - coords.getY()) * 16) + this.camera.y + (float)this.height * this.camera.scale;
        return new float[]{pixelX, pixelY};
    }

    public GridPosition pixelToTile(float x, float y) {
        int tileX = (int)(((x += 7.0f) - 2.0f * (y += 1.0f)) * 0.0156f);
        int tileY = (int)((x + 2.0f * y) * 0.0156f);
        try {
            return new GridPosition(tileX + 39, tileY - 44);
        }
        catch (IllegalArgumentException e) {
            return new GridPosition(10000, 10000);
        }
    }

    public GridPosition currentGridPosition() {
        return this.pixelToTile(this.cursorScreenPos.x * this.camera.scale + this.camera.x, this.cursorScreenPos.y * this.camera.scale + this.camera.y);
    }

    public void renderBuilding(Building building) {
        if (this.deleteMode && building.getArea().contains(this.currentGridPosition()) && !(building instanceof ObstacleBuilding)) {
            this.game.spritebatch.setColor(INVALID_PREVIEW);
        } else if (building.getAge() < 1200) {
            if (this.gameState.isPaused()) {
                this.game.spritebatch.setColor(NOT_BUILT);
            } else {
                float opacity = ((float)Math.sin((double)System.currentTimeMillis() * 0.005) + 3.0f) / 5.0f;
                if (this.gameState.getCurrentEvent() instanceof SnowEvent || this.gameState.getCurrentEvent() instanceof FloodEvent) {
                    opacity /= 2.0f;
                }
                this.game.spritebatch.setColor(new Color(World.NOT_BUILT.r, World.NOT_BUILT.g, World.NOT_BUILT.b, ((float)Math.sin((double)System.currentTimeMillis() * 0.005) + 3.0f) / 5.0f));
            }
        }
        Texture texture = this.game.getAsset(building.getTexturePath());
        float[] pixelCoords = this.tileToPixel(building.getArea().getOrigin());
        this.game.spritebatch.draw(texture, pixelCoords[0] / this.camera.scale, (pixelCoords[1] - (float)(building.getArea().getHeight() * 16)) / this.camera.scale, 2.0f * (float)texture.getWidth() / this.camera.scale, 2.0f * (float)texture.getHeight() / this.camera.scale, 0, 0, texture.getWidth(), texture.getHeight(), building.getFlipped(), false);
        Color color = this.game.spritebatch.getColor();
        if (building.getAge() < 1200 && !this.gameState.isPaused()) {
            color.a /= 2.0f;
        }
        if (this.gameState.getCurrentEvent() instanceof SnowEvent) {
            color.a *= (float)Math.sqrt(this.gameState.getCurrentEvent().getIntensity());
            this.game.spritebatch.setColor(color);
            texture = this.game.getAsset(building.getTexturePathSnow());
            this.game.spritebatch.draw(texture, pixelCoords[0] / this.camera.scale, (pixelCoords[1] - (float)(building.getArea().getHeight() * 16)) / this.camera.scale, 2.0f * (float)texture.getWidth() / this.camera.scale, 2.0f * (float)texture.getHeight() / this.camera.scale, 0, 0, texture.getWidth(), texture.getHeight(), building.getFlipped(), false);
        } else if (this.gameState.getCurrentEvent() instanceof FloodEvent) {
            color.a *= (float)Math.sqrt(this.gameState.getCurrentEvent().getIntensity());
            this.game.spritebatch.setColor(color);
            texture = this.game.getAsset(building.getTexturePathFlood());
            this.game.spritebatch.draw(texture, pixelCoords[0] / this.camera.scale, (pixelCoords[1] - (float)(building.getArea().getHeight() * 16)) / this.camera.scale, 2.0f * (float)texture.getWidth() / this.camera.scale, 2.0f * (float)texture.getHeight() / this.camera.scale, 0, 0, texture.getWidth(), texture.getHeight(), building.getFlipped(), false);
        }
        this.game.spritebatch.setColor(NORMAL);
    }

    public void render(float delta) {
        this.game.spritebatch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.viewport.apply();
        ScreenUtils.clear(0.2f, 0.6f, 0.8f, 1.0f);
        this.camera.updateZoom(delta);
        this.game.spritebatch.begin();
        this.game.spritebatch.setColor(NORMAL);
        this.game.spritebatch.draw(this.gameMap[0], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        this.game.spritebatch.draw(this.gameMap[1], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.gameMap[0].getWidth() + 3, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        this.game.spritebatch.draw(this.gameMap[2], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y - this.gameMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        this.game.spritebatch.draw(this.gameMap[3], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.gameMap[0].getWidth() + 3, (int)this.camera.y - this.gameMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        if (this.gameState.getCurrentEvent() instanceof SnowEvent) {
            this.game.spritebatch.setColor(new Color(1.0f, 1.0f, 1.0f, (float)Math.sqrt(this.gameState.getCurrentEvent().getIntensity())));
            this.game.spritebatch.draw(this.snowyMap[0], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.snowyMap[1], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.snowyMap[0].getWidth() + 3, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.snowyMap[2], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y - this.snowyMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.snowyMap[3], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.snowyMap[0].getWidth() + 3, (int)this.camera.y - this.snowyMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        } else if (this.gameState.getCurrentEvent() instanceof FloodEvent) {
            this.game.spritebatch.setColor(new Color(1.0f, 1.0f, 1.0f, (float)Math.sqrt(this.gameState.getCurrentEvent().getIntensity())));
            this.game.spritebatch.draw(this.floodedMap[0], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.floodedMap[1], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.floodedMap[0].getWidth() + 3, (int)this.camera.y + 1, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.floodedMap[2], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x + 1, (int)this.camera.y - this.floodedMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
            this.game.spritebatch.draw(this.floodedMap[3], 0.0f, 0.0f, (float)this.width, (float)this.height, (int)this.camera.x - this.floodedMap[0].getWidth() + 3, (int)this.camera.y - this.floodedMap[0].getHeight() + 3, (int)((float)this.width * this.camera.scale), (int)((float)this.height * this.camera.scale), false, false);
        }
        this.game.spritebatch.setColor(NORMAL);
        this.buildings.forEach(this::renderBuilding);
        if (this.selectedBuilding != null) {
            if (!this.gameState.canPlaceBuilding(this.selectedBuilding)) {
                this.game.spritebatch.setColor(INVALID_PREVIEW);
            } else {
                this.game.spritebatch.setColor(TRANSPARENT_PREVIEW);
            }
            this.renderBuilding(this.selectedBuilding);
            this.game.spritebatch.setColor(NORMAL);
        }
        if (this.gameState.getCurrentEvent() != null) {
            this.gameState.getCurrentEvent().render(delta);
        }
        this.game.spritebatch.end();
        if (this.gameState.isTimeUp()) {
            this.camera.velocityReset();
        }
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.camera.resize(width, height);
        this.viewport.update(width, height, true);
    }

    public void setSelectedBuilding(Building building) {
        this.selectedBuilding = building;
        if (building != null) {
            this.selectedBuilding.setAge(1200);
        }
    }

    public Main getGame() {
        return this.game;
    }

    public void undoPlacement() {
        Gdx.app.log("#INFO", "Recently Placed: " + this.recentlyPlaced.size());
        if (this.recentlyPlaced.size() == 0) {
            return;
        }
        Building removed = this.buildings.get(this.recentlyPlaced.pop());
        this.removeObject(removed.getPosition());
    }

    @Generated
    public GameState getGameState() {
        return this.gameState;
    }

    @Generated
    public void setCursorScreenPos(Vector3 cursorScreenPos) {
        this.cursorScreenPos = cursorScreenPos;
    }

    @Generated
    public Camera getCamera() {
        return this.camera;
    }

    @Generated
    public List<Building> getBuildings() {
        return this.buildings;
    }

    @Generated
    public Viewport getViewport() {
        return this.viewport;
    }

    @Generated
    public void setDeleteMode(boolean deleteMode) {
        this.deleteMode = deleteMode;
    }

    @Generated
    public MapScreen getParentScreen() {
        return this.parentScreen;
    }
}

