/*
 * Decompiled with CFR 0.152.
 */
package y111studios;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import y111studios.BuildingMenu;
import y111studios.GameState;
import y111studios.World;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.VariantProperties;
import y111studios.screens.InstructionsScreen;

public class WorldInputProcessor
implements InputProcessor {
    private final World world;
    private final BuildingMenu buildingMenu;
    private int cursorX;
    private int cursorY;
    private int clickX;
    private int clickY;
    private boolean clickedOnMap = false;
    private boolean dragging = true;
    private List<Integer> keysDown = new ArrayList<Integer>(3);

    public WorldInputProcessor(World world, BuildingMenu buildingMenu) {
        this.world = world;
        this.buildingMenu = buildingMenu;
    }

    @Override
    public boolean keyDown(int keyCode) {
        this.keysDown.add(keyCode);
        if ((this.keysDown.contains(129) || this.keysDown.contains(130)) && this.keysDown.contains(54)) {
            this.world.undoPlacement();
        }
        GameState state = this.world.getGameState();
        switch (keyCode) {
            case 8: {
                this.setItem(0);
                break;
            }
            case 9: {
                this.setItem(1);
                break;
            }
            case 10: {
                this.setItem(2);
                break;
            }
            case 11: {
                this.setItem(3);
                break;
            }
            case 12: {
                this.setItem(4);
                break;
            }
            case 46: {
                this.buildingMenu.flipBuildings();
                break;
            }
            case 32: {
                this.setItem(6);
                break;
            }
            case 61: {
                this.buildingMenu.updateTab((this.buildingMenu.getCurrentMenuTab().toInt() + 1) % 5);
                break;
            }
            case 49: {
                this.world.undoPlacement();
                break;
            }
            case 62: {
                if (state.isPaused()) {
                    state.resume();
                    break;
                }
                state.pause();
                break;
            }
            case 111: {
                this.buildingMenu.setCurrentMenuItem(-1);
                break;
            }
            case 37: {
                InstructionsScreen instructionsScreen = new InstructionsScreen(this.world.getGame(), this.world.getGame().getScreen());
                this.world.getGame().setScreen(instructionsScreen);
                break;
            }
        }
        return false;
    }

    private void setItem(int item) {
        if (this.buildingMenu.getCurrentMenuItem() == item) {
            this.buildingMenu.setCurrentMenuItem(-1);
        } else {
            this.buildingMenu.setCurrentMenuItem(item);
        }
    }

    @Override
    public boolean keyUp(int keyCode) {
        this.keysDown.remove((Object)keyCode);
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.world.getViewport().getWorldHeight() - (float)screenY < (float)this.buildingMenu.getScreenHeight()) {
            return false;
        }
        float infoBarHeight = this.world.getParentScreen().getInfoBar().getInfoBarHeight();
        if ((float)screenY < infoBarHeight) {
            return false;
        }
        this.clickX = this.cursorX = screenX;
        this.clickY = this.cursorY = screenY;
        this.clickedOnMap = true;
        this.dragging = false;
        return true;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        this.clickedOnMap = false;
        if (!this.dragging) {
            Vector3 screenPos = this.world.getViewport().getCamera().unproject(new Vector3(x, y, 0.0f), this.world.getViewport().getScreenX(), this.world.getViewport().getScreenY(), this.world.getViewport().getScreenWidth(), this.world.getViewport().getScreenHeight());
            if (this.buildingMenu.getCurrentMenuItem() >= 0 && this.buildingMenu.getCurrentMenuItem() < 5) {
                VariantProperties variant = this.buildingMenu.getBuildingVariants().get((Object)this.buildingMenu.getCurrentMenuTab())[this.buildingMenu.getCurrentMenuItem()];
                if (this.world.addObject(variant, this.world.currentGridPosition(), this.buildingMenu.isFlipped()) && variant != MiscellaneousVariant.STRAIGHT_ROAD && variant != MiscellaneousVariant.ROAD_CROSS && variant != MiscellaneousVariant.ROAD_BEND1 && variant != MiscellaneousVariant.ROAD_BEND2) {
                    this.buildingMenu.setCurrentMenuItem(-1);
                }
            } else if (this.buildingMenu.getCurrentMenuItem() == 6) {
                this.world.removeObject(this.world.currentGridPosition());
            }
        }
        this.dragging = true;
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        this.world.setCursorScreenPos(new Vector3(x, y, 0.0f));
        if (this.clickedOnMap) {
            if (Math.max(Math.abs(this.cursorX - this.clickX), Math.abs(this.cursorY - this.clickY)) > 5) {
                this.dragging = true;
            }
            this.world.getCamera().pan(this.cursorX - x, this.cursorY - y);
            this.cursorX = x;
            this.cursorY = y;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean mouseMoved(int x, int y) {
        this.world.setDeleteMode(this.buildingMenu.getCurrentMenuItem() == 6);
        this.world.setCursorScreenPos(new Vector3(x, y, 0.0f));
        return true;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        this.world.getCamera().zoomV += 0.001f * amountY;
        return true;
    }
}

