/*
 * Decompiled with CFR 0.152.
 */
package y111studios.achievements;

import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.GameState;
import y111studios.World;
import y111studios.achievements.AchievementManager;
import y111studios.screens.MapScreen;

public abstract class Achievement {
    private World world;
    private String name;
    private AchievementManager manager;
    private String displayName;
    private String description;
    private final int scoreContribution;
    private AssetPaths notificationPath;

    public Achievement(String name, AchievementManager manager, String displayName, String description, int scoreContribution, World world, AssetPaths notificationPath) {
        this.name = name;
        this.manager = manager;
        this.displayName = displayName;
        this.description = description;
        this.scoreContribution = scoreContribution;
        this.world = world;
        this.notificationPath = notificationPath;
        if (manager.getAchievements().containsKey(name)) {
            throw new IllegalArgumentException("Achievement names must be unique");
        }
    }

    public abstract boolean condition();

    public void result() {
        if (this.world.getGame() != null) {
            MapScreen screen = (MapScreen)this.world.getGame().getScreen();
            screen.getNotificationManager().createNotification(500, this.notificationPath);
        }
        GameState gameState = this.world.getGameState();
        gameState.getScoreManager().addScore(this.scoreContribution);
    }

    public boolean isComplete() {
        return this.manager.getCompletedAchievements().containsKey(this.name);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

