/*
 * Decompiled with CFR 0.152.
 */
package y111studios.achievements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import main.java.y111studios.achievements.HesitantAchievement;
import y111studios.AssetPaths;
import y111studios.World;
import y111studios.achievements.Achievement;
import y111studios.achievements.BuildingHoarderAchievement;
import y111studios.achievements.SatisfactionAchievement;

public class AchievementManager {
    World world;
    private Map<String, Achievement> achievements;
    private Map<String, Achievement> completedAchievements;

    public AchievementManager(World world) {
        this.world = world;
        this.achievements = new HashMap<String, Achievement>();
        this.completedAchievements = new HashMap<String, Achievement>();
    }

    public void add(Achievement achievement) {
        if (this.achievements.containsKey(achievement.getName())) {
            throw new IllegalArgumentException("Achievement names must be unique");
        }
        this.achievements.put(achievement.getName(), achievement);
    }

    public void checkConditions() {
        HashSet<Achievement> achievementsToAward = new HashSet<Achievement>();
        for (String key : this.achievements.keySet()) {
            Achievement achievement = this.achievements.get(key);
            if (!achievement.condition()) continue;
            achievementsToAward.add(achievement);
        }
        for (Achievement achievement : achievementsToAward) {
            this.awardAchievement(achievement);
        }
    }

    public void awardAchievement(Achievement achievement) {
        this.achievements.remove(achievement.getName());
        this.completedAchievements.put(achievement.getName(), achievement);
        achievement.result();
    }

    public void setupAchievements() {
        this.add(new SatisfactionAchievement("satisfactionAchievement", this, this.world, AssetPaths.SATISFACTION_ACHIEVEMENT));
        this.add(new BuildingHoarderAchievement("buildingHoarderAchievement", this, this.world, AssetPaths.BUILDING_HOARDER_ACHIEVEMENT));
        this.add(new HesitantAchievement("hesitantAchievement", this, this.world, AssetPaths.HESITANT_ACHIEVEMENT));
    }

    @Generated
    public Map<String, Achievement> getAchievements() {
        return this.achievements;
    }

    @Generated
    public Map<String, Achievement> getCompletedAchievements() {
        return this.completedAchievements;
    }
}

