/*
 * Decompiled with CFR 0.152.
 */
package y111studios.buildings;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import y111studios.buildings.Building;
import y111studios.buildings.BuildingType;

public class BuildingCounter {
    private final Map<BuildingType, Integer> buildingMap = new HashMap<BuildingType, Integer>();
    private int count;

    public BuildingCounter() {
        for (BuildingType type : BuildingType.values()) {
            this.buildingMap.put(type, 0);
        }
        this.count = 0;
    }

    public void placeBuilding(BuildingType type) {
        this.buildingMap.put(type, this.buildingMap.get((Object)type) + 1);
        ++this.count;
    }

    public void placeBuilding(Building building) {
        BuildingType type = BuildingType.fromBuilding(building);
        this.placeBuilding(type);
    }

    public void removeBuilding(BuildingType type) {
        this.buildingMap.put(type, this.buildingMap.get((Object)type) - 1);
        --this.count;
    }

    public void removeBuilding(Building building) {
        BuildingType type = BuildingType.fromBuilding(building);
        this.removeBuilding(type);
    }

    public int getBuildingCount(BuildingType type) {
        return this.buildingMap.get((Object)type);
    }

    public int getTotalCount() {
        return this.count;
    }

    public void reset() {
        for (BuildingType type : BuildingType.values()) {
            this.buildingMap.put(type, 0);
        }
        this.count = 0;
    }

    @Generated
    public Map<BuildingType, Integer> getBuildingMap() {
        return this.buildingMap;
    }

    @Generated
    public int getCount() {
        return this.count;
    }
}

