/*
 * Decompiled with CFR 0.152.
 */
package y111studios.buildings;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import y111studios.buildings.AccommodationBuilding;
import y111studios.buildings.Building;
import y111studios.buildings.CateringBuilding;
import y111studios.buildings.MiscellaneousBuilding;
import y111studios.buildings.ObstacleBuilding;
import y111studios.buildings.RecreationBuilding;
import y111studios.buildings.TeachingBuilding;
import y111studios.buildings.premade_variants.AccommodationVariant;
import y111studios.buildings.premade_variants.CateringVariant;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.ObstacleVariant;
import y111studios.buildings.premade_variants.RecreationVariant;
import y111studios.buildings.premade_variants.TeachingVariant;
import y111studios.buildings.premade_variants.VariantProperties;
import y111studios.position.GridPosition;
import y111studios.utils.UnreachableException;

public final class BuildingFactory {
    private static final Map<Class<? extends VariantProperties>, Constructor<? extends Building>> CONSTRUCTORS = new HashMap<Class<? extends VariantProperties>, Constructor<? extends Building>>(5);

    private static <V extends VariantProperties> void tryRegisterConstructor(Class<V> variantClass, Class<? extends Building> buildingClass) {
        Constructor<? extends Building> constructor;
        try {
            constructor = buildingClass.getConstructor(GridPosition.class, variantClass, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new UnreachableException("Constructor undefined", e);
        }
        catch (SecurityException e) {
            throw new UnreachableException("Constructor cannot be accessed", e);
        }
        CONSTRUCTORS.put(variantClass, constructor);
    }

    public static Building createBuilding(VariantProperties variant, GridPosition position, boolean flipped) {
        if (variant == null) {
            throw new IllegalArgumentException("BuildingProperties must not be null");
        }
        if (position == null) {
            throw new IllegalArgumentException("GridPosition must not be null");
        }
        Constructor<? extends Building> constructor = CONSTRUCTORS.get(variant.getVariantClass());
        try {
            return constructor.newInstance(position, variant, flipped);
        }
        catch (Exception e) {
            throw new UnreachableException("Constructors defined at startup should be correct");
        }
    }

    static {
        try {
            BuildingFactory.tryRegisterConstructor(AccommodationVariant.class, AccommodationBuilding.class);
            BuildingFactory.tryRegisterConstructor(CateringVariant.class, CateringBuilding.class);
            BuildingFactory.tryRegisterConstructor(RecreationVariant.class, RecreationBuilding.class);
            BuildingFactory.tryRegisterConstructor(TeachingVariant.class, TeachingBuilding.class);
            BuildingFactory.tryRegisterConstructor(MiscellaneousVariant.class, MiscellaneousBuilding.class);
            BuildingFactory.tryRegisterConstructor(ObstacleVariant.class, ObstacleBuilding.class);
        }
        catch (UnreachableException e) {
            System.exit(1);
        }
    }
}

