/*
 * Decompiled with CFR 0.152.
 */
package y111studios.buildings;

import java.util.OptionalInt;
import lombok.Generated;
import y111studios.buildings.Building;
import y111studios.buildings.BuildingController;
import y111studios.buildings.BuildingCounter;
import y111studios.position.GridPosition;

public class BuildingManager
implements BuildingController {
    public static final int MAX_BUILDINGS = 254;
    private final Building[] buildings = new Building[254];
    public BuildingCounter counter = new BuildingCounter();

    private Building popLast() {
        int index = this.getCount() - 1;
        if (index < 0) {
            return null;
        }
        Building building = this.buildings[index];
        this.buildings[index] = null;
        return building;
    }

    public boolean removeIndex(int index) {
        Building removed;
        int length = this.getCount();
        if (index < 0 || index >= length) {
            return false;
        }
        if (index == length - 1) {
            removed = this.popLast();
        } else {
            removed = this.buildings[index];
            this.buildings[index] = this.popLast();
        }
        this.counter.removeBuilding(removed);
        return true;
    }

    public OptionalInt indexContainingPosition(GridPosition position) {
        if (position == null) {
            return OptionalInt.empty();
        }
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.buildings[i].contains(position)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public Building getBuilding(GridPosition position) {
        OptionalInt index = this.indexContainingPosition(position);
        if (index.isEmpty()) {
            return null;
        }
        return this.buildings[index.getAsInt()];
    }

    @Override
    public boolean push(Building building) {
        if (building == null) {
            return true;
        }
        int index = this.counter.getTotalCount();
        if (this.isFull()) {
            return false;
        }
        this.buildings[index] = building;
        this.counter.placeBuilding(building);
        return true;
    }

    @Override
    public boolean removePosition(GridPosition position) {
        OptionalInt index = this.indexContainingPosition(position);
        if (index.isEmpty()) {
            return false;
        }
        return this.removeIndex(index.getAsInt());
    }

    @Override
    public int getCount() {
        return this.counter.getTotalCount();
    }

    @Override
    public boolean isFull() {
        return this.getCount() >= 254;
    }

    public void tick() {
        for (Building building : this.buildings) {
            if (building == null) continue;
            building.tick();
        }
    }

    @Generated
    public Building[] getBuildings() {
        return this.buildings;
    }

    @Generated
    public BuildingCounter getCounter() {
        return this.counter;
    }
}

