/*
 * Decompiled with CFR 0.152.
 */
package y111studios.buildings;

import y111studios.buildings.AccommodationBuilding;
import y111studios.buildings.Building;
import y111studios.buildings.CateringBuilding;
import y111studios.buildings.MiscellaneousBuilding;
import y111studios.buildings.RecreationBuilding;
import y111studios.buildings.TeachingBuilding;

public enum BuildingType {
    ACCOMMODATION,
    CATERING,
    RECREATION,
    TEACHING,
    MISCELLANEOUS;


    public static BuildingType fromBuilding(Building building) {
        if (building == null) {
            throw new IllegalArgumentException("Building cannot be null.");
        }
        if (building instanceof AccommodationBuilding) {
            return ACCOMMODATION;
        }
        if (building instanceof CateringBuilding) {
            return CATERING;
        }
        if (building instanceof RecreationBuilding) {
            return RECREATION;
        }
        if (building instanceof TeachingBuilding) {
            return TEACHING;
        }
        if (building instanceof MiscellaneousBuilding) {
            return MISCELLANEOUS;
        }
        throw new IllegalArgumentException("Building type not recognised.");
    }
}

