/*
 * Decompiled with CFR 0.152.
 */
package y111studios.buildings;

import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.position.GridArea;
import y111studios.position.GridPosition;

public abstract class MapObject {
    protected GridArea area;
    protected AssetPaths texturePath;
    protected AssetPaths texturePathSnow;
    protected AssetPaths texturePathFlood;
    protected int age;
    protected boolean flipped;
    public static final int BUILDING_TIME = 1200;

    protected MapObject(GridArea area, AssetPaths texturePath, AssetPaths texturePathSnow, AssetPaths texturePathFlood, boolean flipped) {
        if (area == null) {
            throw new IllegalArgumentException("GridArea must not be null");
        }
        if (texturePath == null) {
            throw new IllegalArgumentException("Texture Path must not be null");
        }
        this.area = area;
        this.texturePath = texturePath;
        this.texturePathSnow = texturePathSnow;
        this.texturePathFlood = texturePathFlood;
        this.flipped = flipped;
        this.age = 0;
    }

    public boolean contains(GridPosition position) {
        return this.area.contains(position);
    }

    public boolean getFlipped() {
        return this.flipped;
    }

    public void tick() {
        ++this.age;
    }

    @Generated
    public GridArea getArea() {
        return this.area;
    }

    @Generated
    public AssetPaths getTexturePath() {
        return this.texturePath;
    }

    @Generated
    public AssetPaths getTexturePathSnow() {
        return this.texturePathSnow;
    }

    @Generated
    public AssetPaths getTexturePathFlood() {
        return this.texturePathFlood;
    }

    @Generated
    public void setAge(int age) {
        this.age = age;
    }

    @Generated
    public int getAge() {
        return this.age;
    }
}

