/*
 * Decompiled with CFR 0.152.
 */
package y111studios.clock;

import java.time.Duration;
import java.time.Instant;
import y111studios.clock.GameTimer;

public class Clock
implements GameTimer {
    private Duration totalDuration = Duration.ZERO;
    private Instant start;

    public Clock() {
        this.start = null;
    }

    Clock(Instant start) {
        this.start = start;
    }

    private Duration elapsedSessionTime() {
        Instant now = Instant.now();
        if (this.isPaused()) {
            return Duration.ZERO;
        }
        return Duration.between(this.start, now);
    }

    private Duration totalElapsedTime() {
        Duration sessionTime = this.elapsedSessionTime();
        return this.totalDuration.plusNanos(sessionTime.toNanos());
    }

    @Override
    public boolean isPaused() {
        return this.start == null;
    }

    @Override
    public boolean isTimeUp() {
        boolean isTimeUp;
        boolean bl = isTimeUp = this.totalElapsedTime().compareTo(INITIAL_DURATION) >= 0;
        if (isTimeUp) {
            this.totalDuration = INITIAL_DURATION;
        }
        return isTimeUp;
    }

    @Override
    public Duration timeRemaining() {
        return INITIAL_DURATION.minus(this.totalElapsedTime());
    }

    @Override
    public void pause() {
        if (this.isPaused()) {
            return;
        }
        Duration session = this.elapsedSessionTime();
        this.totalDuration = this.totalDuration.plusNanos(session.toNanos());
        this.start = null;
    }

    @Override
    public void resume() {
        if (!this.isPaused() || this.isTimeUp()) {
            return;
        }
        this.start = Instant.now();
    }
}

