/*
 * Decompiled with CFR 0.152.
 */
package y111studios.events;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import java.util.Random;
import y111studios.AssetPaths;
import y111studios.Camera;
import y111studios.GameState;
import y111studios.Main;
import y111studios.events.Event;

public class FloodEvent
extends Event {
    private static final Vector3 minStart = new Vector3(-3000.0f, -5000.0f, 1.0f);
    private static final Vector3 maxStart = new Vector3(7500.0f, 2000.0f, 9.0f);
    private Vector3[] snowflakes;
    private final Main game;
    private GameState gameState;
    private Camera camera;
    private Texture raindropTexture;
    private Random random = new Random();

    public FloodEvent(Main game, GameState gameState, Camera camera) {
        super(game, AssetPaths.FLOOD_EVENT);
        this.game = game;
        this.gameState = gameState;
        this.camera = camera;
        this.snowflakes = new Vector3[50000];
        if (game != null) {
            this.raindropTexture = game.getAsset(AssetPaths.RAINDROP);
        }
        for (int i = 0; i < 50000; ++i) {
            this.snowflakes[i] = new Vector3(FloodEvent.minStart.x + this.random.nextFloat() * (FloodEvent.maxStart.x - FloodEvent.minStart.x), FloodEvent.minStart.y + this.random.nextFloat() * (FloodEvent.maxStart.y - FloodEvent.minStart.y), FloodEvent.minStart.z + this.random.nextFloat() * (FloodEvent.maxStart.z - FloodEvent.minStart.z));
        }
    }

    @Override
    public void render(float delta) {
        int numSnowflakes = (int)(this.getIntensity() * 50000.0f);
        for (int i = 0; i < numSnowflakes; ++i) {
            if (!this.gameState.isPaused()) {
                this.snowflakes[i].y -= this.snowflakes[i].z * delta * 500.0f;
                this.snowflakes[i].z *= (float)Math.pow(0.6f, delta);
                if (this.snowflakes[i].z < 1.0f) {
                    this.snowflakes[i].x = FloodEvent.minStart.x + this.random.nextFloat() * (FloodEvent.maxStart.x - FloodEvent.minStart.x);
                    this.snowflakes[i].y = FloodEvent.minStart.y + this.random.nextFloat() * (FloodEvent.maxStart.y - FloodEvent.minStart.y);
                    this.snowflakes[i].z = FloodEvent.minStart.z + this.random.nextFloat() * (FloodEvent.maxStart.z - FloodEvent.minStart.z);
                }
            }
            this.game.spritebatch.draw(this.raindropTexture, (this.snowflakes[i].x - this.camera.x) / this.camera.scale, (this.snowflakes[i].y + this.camera.y + (float)this.camera.height * this.camera.scale) / this.camera.scale, this.snowflakes[i].z / this.camera.scale, this.snowflakes[i].z / this.camera.scale * 4.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public float getIntensity() {
        int timeSinceEventStart = this.gameState.getNumTicks() % 3720;
        return (float)Math.sin((double)((float)timeSinceEventStart / 3720.0f) * Math.PI);
    }
}

