/*
 * Decompiled with CFR 0.152.
 */
package y111studios.events;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector3;
import java.util.Random;
import y111studios.AssetPaths;
import y111studios.Camera;
import y111studios.GameState;
import y111studios.Main;
import y111studios.events.Event;

public class SnowEvent
extends Event {
    private static final Vector3 minStartPoint = new Vector3(-3000.0f, -5000.0f, 1.0f);
    private static final Vector3 maxStartPoint = new Vector3(7500.0f, 2000.0f, 30.0f);
    private Vector3[] snowflakes;
    private final Main game;
    private GameState gameState;
    private Camera camera;
    private Texture snowflakeTexture;
    private Random random = new Random();

    public SnowEvent(Main game, GameState gameState, Camera camera) {
        super(game, AssetPaths.SNOW_EVENT);
        this.game = game;
        this.gameState = gameState;
        this.camera = camera;
        this.snowflakes = new Vector3[50000];
        if (game != null) {
            this.snowflakeTexture = game.getAsset(AssetPaths.SNOWFLAKE);
            for (int i = 0; i < 50000; ++i) {
                this.snowflakes[i] = new Vector3(SnowEvent.minStartPoint.x + this.random.nextFloat() * (SnowEvent.maxStartPoint.x - SnowEvent.minStartPoint.x), SnowEvent.minStartPoint.y + this.random.nextFloat() * (SnowEvent.maxStartPoint.y - SnowEvent.minStartPoint.y), SnowEvent.minStartPoint.z + this.random.nextFloat() * (SnowEvent.maxStartPoint.z - SnowEvent.minStartPoint.z));
            }
        }
    }

    @Override
    public void render(float delta) {
        int timeSinceEventStart = this.gameState.getNumTicks() % 3720;
        int numSnowflakes = (int)(this.getIntensity() * 50000.0f);
        for (int i = 0; i < numSnowflakes; ++i) {
            if (!this.gameState.isPaused()) {
                this.snowflakes[i].x = (float)((double)this.snowflakes[i].x + Math.sin(this.snowflakes[i].z) * (double)this.snowflakes[i].z * (double)0.08f);
                this.snowflakes[i].y -= this.snowflakes[i].z * delta * 10.0f;
                this.snowflakes[i].z *= (float)Math.pow(0.6f, delta);
                if (this.snowflakes[i].z < 1.0f) {
                    this.snowflakes[i].x = SnowEvent.minStartPoint.x + this.random.nextFloat() * (SnowEvent.maxStartPoint.x - SnowEvent.minStartPoint.x);
                    this.snowflakes[i].y = SnowEvent.minStartPoint.y + this.random.nextFloat() * (SnowEvent.maxStartPoint.y - SnowEvent.minStartPoint.y);
                    this.snowflakes[i].z = SnowEvent.minStartPoint.z + this.random.nextFloat() * (SnowEvent.maxStartPoint.z - SnowEvent.minStartPoint.z);
                }
            }
            this.game.spritebatch.draw(this.snowflakeTexture, (this.snowflakes[i].x - this.camera.x) / this.camera.scale, (this.snowflakes[i].y + this.camera.y + (float)this.camera.height * this.camera.scale) / this.camera.scale, this.snowflakes[i].z / this.camera.scale, this.snowflakes[i].z / this.camera.scale, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public float getIntensity() {
        int timeSinceEventStart = this.gameState.getNumTicks() % 3720;
        return (float)Math.sin((double)((float)timeSinceEventStart / 3720.0f) * Math.PI);
    }
}

