/*
 * Decompiled with CFR 0.152.
 */
package y111studios.map;

import y111studios.position.GridArea;
import y111studios.position.GridPosition;

public class CollisionDetection {
    private final boolean[][] buildingGrid;
    private final GridArea mapArea;

    public CollisionDetection(int width, int height) {
        this.buildingGrid = new boolean[width][height];
        this.mapArea = new GridArea(0, 0, width, height);
    }

    public CollisionDetection(int width, int height, int[][] staticObjects) {
        this(width, height);
        for (int i = 0; i < staticObjects.length; ++i) {
            this.fillArea(new GridArea(staticObjects[i][0], staticObjects[i][1], staticObjects[i][2], staticObjects[i][3]), true);
        }
    }

    private boolean withinBounds(GridArea area) {
        return this.mapArea.contains(area);
    }

    private boolean withinBounds(GridPosition position) {
        return this.mapArea.contains(position);
    }

    public boolean canPlaceBuilding(GridArea area) {
        if (!this.withinBounds(area)) {
            return false;
        }
        for (int x = area.getX(); x < area.getX() + area.getWidth(); ++x) {
            for (int y = area.getY(); y < area.getY() + area.getHeight(); ++y) {
                if (!this.buildingGrid[x][y]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canPlaceBuilding(GridPosition position) {
        if (!this.withinBounds(position)) {
            return false;
        }
        return this.buildingGrid[position.getX()][position.getY()];
    }

    public boolean placeBuilding(GridArea area) {
        if (!this.canPlaceBuilding(area)) {
            return false;
        }
        this.fillArea(area, true);
        return true;
    }

    public boolean removeBuilding(GridArea area) {
        if (!this.withinBounds(area)) {
            return false;
        }
        this.fillArea(area, false);
        return true;
    }

    private void fillArea(GridArea area, boolean value) {
        for (int x = area.getX(); x < area.getX() + area.getWidth(); ++x) {
            for (int y = area.getY(); y < area.getY() + area.getHeight(); ++y) {
                this.buildingGrid[x][y] = value;
            }
        }
    }
}

