/*
 * Decompiled with CFR 0.152.
 */
package y111studios.notification;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Queue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.notification.Notification;

public class NotificationManager {
    private final Main game;
    private static int MAX_NOTIFICATIONS = 3;
    private ArrayList<Cell<Image>> notificationCells = new ArrayList(MAX_NOTIFICATIONS);
    private ArrayList<Notification> activeNotifications = new ArrayList(MAX_NOTIFICATIONS);
    private Queue<Notification> queuedNotifications = new Queue();

    public NotificationManager(Table table, Main game) {
        this.game = game;
        for (int i = 0; i < MAX_NOTIFICATIONS; ++i) {
            Cell<Image> cell = table.add(new Image());
            cell.pad(0.02f);
            this.notificationCells.add(cell);
            cell.setActor(null);
            table.row();
        }
    }

    public void tick() {
        Notification notification;
        int size = this.activeNotifications.size();
        Iterator<Notification> it = this.activeNotifications.iterator();
        while (it.hasNext()) {
            notification = it.next();
            if (notification != null) continue;
            it.remove();
        }
        if (size != this.activeNotifications.size()) {
            Gdx.app.log("#INFO", "Null items removed");
        }
        for (int i = 0; i < this.activeNotifications.size(); ++i) {
            notification = this.activeNotifications.get(i);
            if (notification == null || notification.tick()) continue;
            this.activeNotifications.set(i, null);
        }
        while (this.activeNotifications.size() < MAX_NOTIFICATIONS && this.queuedNotifications.size > 0) {
            this.activeNotifications.add(this.queuedNotifications.removeFirst());
        }
        this.activeNotifications.sort(new NotificationComparator());
        this.drawNotifications();
    }

    private void drawNotifications() {
        if (this.activeNotifications.size() == 0) {
            return;
        }
        for (int i = 0; i < this.activeNotifications.size(); ++i) {
            Notification notification = this.activeNotifications.get(i);
            Cell<Image> cell = this.notificationCells.get(i);
            if (notification == null) {
                cell.setActor(null);
                continue;
            }
            Image image = notification.getImage();
            image.addListener(new ClickToDismissListener(notification));
            cell.setActor(image);
        }
    }

    public void createNotification(int maxAge, AssetPaths path) {
        Gdx.app.log("#INFO", "Notification Created!");
        if (path == null) {
            throw new IllegalArgumentException("Notification must have a non-null asset path");
        }
        Notification notification = new Notification(maxAge, path, this.game);
        this.queuedNotifications.addLast(notification);
    }

    public void resize(int width, int height) {
        for (Cell<Image> cell : this.notificationCells) {
            cell.width((float)height * 0.3f).height((float)height * 0.15f);
        }
    }

    class NotificationComparator
    implements Comparator<Notification> {
        NotificationComparator() {
        }

        @Override
        public int compare(Notification notification, Notification otherNotification) {
            if (notification == null) {
                return 1;
            }
            if (otherNotification == null) {
                return -1;
            }
            return notification.getMaxAge() - notification.getAge() - (otherNotification.getMaxAge() - otherNotification.getAge());
        }
    }

    class ClickToDismissListener
    extends InputListener {
        private Notification notification;

        public ClickToDismissListener(Notification notification) {
            this.notification = notification;
        }

        @Override
        public boolean touchDown(InputEvent e, float x, float y, int pointer, int parent) {
            this.notification.remove();
            return false;
        }
    }
}

