/*
 * Decompiled with CFR 0.152.
 */
package y111studios.position;

import lombok.Generated;
import y111studios.position.GridPosition;
import y111studios.utils.IntRange;

public class GridArea {
    private GridPosition origin;
    private int width;
    private int height;
    private IntRange rangeX = null;
    private IntRange rangeY = null;

    public GridArea(GridPosition origin, int width, int height) {
        if (origin == null) {
            throw new IllegalArgumentException("Origin must not be null");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Width must be greater than 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be greater than 0");
        }
        this.origin = origin;
        this.width = width;
        this.height = height;
    }

    public GridArea(int x, int y, int width, int height) {
        this(new GridPosition(x, y), width, height);
    }

    public int getX() {
        return this.origin.getX();
    }

    public int getY() {
        return this.origin.getY();
    }

    public boolean contains(GridPosition other) {
        if (other == null) {
            return false;
        }
        return this.getRangeX().contains(other.getX()) && this.getRangeY().contains(other.getY());
    }

    public boolean contains(GridArea other) {
        if (other == null) {
            return false;
        }
        return this.getRangeX().contains(other.getRangeX()) && this.getRangeY().contains(other.getRangeY());
    }

    public IntRange getRangeX() {
        if (this.rangeX == null) {
            this.rangeX = this.calculateRangeX();
        }
        return this.rangeX;
    }

    public IntRange getRangeY() {
        if (this.rangeY == null) {
            this.rangeY = this.calculateRangeY();
        }
        return this.rangeY;
    }

    private IntRange calculateRangeX() {
        return new IntRange(this.origin.getX(), this.origin.getX() + this.width);
    }

    private IntRange calculateRangeY() {
        return new IntRange(this.origin.getY(), this.origin.getY() + this.height);
    }

    @Generated
    public GridPosition getOrigin() {
        return this.origin;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }
}

