/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.screens.ScreenWithBackground;
import y111studios.screens.StartScreen;

public class InstructionsScreen
extends ScreenWithBackground {
    public Main game;
    private Stage stage;
    private Table table;
    private static final Skin SKIN = new Skin(Gdx.files.internal("assets/skins/default/uiskin.json"));
    private Cell<Actor> logoCell;
    private Cell<Actor> backButtonCell;
    private TextButton backButton;

    public InstructionsScreen(final Main game, final Screen screen) {
        super(game);
        this.game = game;
        this.backButton = new TextButton("Back", SKIN);
        this.backButton.addListener(new InputListener(this){
            final /* synthetic */ InstructionsScreen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                if (screen == null) {
                    game.setScreen(new StartScreen(game));
                } else {
                    game.setScreen(screen);
                }
                return false;
            }
        });
        this.stage = new Stage(this.viewport);
        this.table = new Table();
        this.table.setFillParent(true);
        Image logo = new Image(game.getAsset(AssetPaths.INSTRUCTIONS));
        this.logoCell = this.table.add(logo);
        this.table.row();
        this.backButtonCell = this.table.add(this.backButton);
        this.stage.addActor(this.table);
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(game.universalInputProcessor);
        inputMultiplexer.addProcessor(this.stage);
        Gdx.input.setInputProcessor(inputMultiplexer);
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.logoCell.width((float)height * 0.8f).height((float)height * 0.8f).pad((float)height * 0.025f);
        float guiScale = (float)height * 0.75f;
        this.backButtonCell.width(guiScale / 3.0f).height((float)height * 0.06f);
        for (Cell cell : this.table.getCells()) {
            if (!(cell.getActor() instanceof TextButton)) continue;
            ((TextButton)cell.getActor()).getLabel().setFontScale((float)height * 0.0015f);
        }
    }
}

