/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.screens.ScreenWithBackground;
import y111studios.screens.StartScreen;
import y111studios.screens.leaderboard.Leaderboard;
import y111studios.screens.leaderboard.LeaderboardScore;

public class LeaderboardScreen
extends ScreenWithBackground {
    private Leaderboard leaderboard;
    private int width = 640;
    private int height = 480;
    private final Image leaderboardTitle;
    private Label[] leaderboardRows;
    private Stage stage;
    private Table table;
    private Cell<TextButton> backButtonCell;
    private Cell<Image> titleCell;
    public static final Skin SKIN = new Skin(Gdx.files.internal("assets/skins/default/uiskin.json"));

    public LeaderboardScreen(final Main game) {
        super(game);
        this.leaderboard = game.leaderboard;
        this.stage = new Stage(this.viewport);
        this.table = new Table(SKIN);
        this.table.setFillParent(true);
        this.leaderboardTitle = new Image(game.getAsset(AssetPaths.LEADERBOARD_TITLE));
        TextButton backButton = new TextButton("Return to Menu", SKIN);
        backButton.addListener(new InputListener(this){
            final /* synthetic */ LeaderboardScreen this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                Gdx.app.log("#INFO", "Back button clicked");
                game.setScreen(new StartScreen(game));
                return false;
            }
        });
        this.stage.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent e, int keycode) {
                if (keycode == 34) {
                    Gdx.app.log("#INFO", "F key pressed");
                }
                return false;
            }
        });
        this.titleCell = this.table.add(this.leaderboardTitle).colspan(2);
        this.createLeaderboard();
        this.backButtonCell = this.table.add(backButton).colspan(2);
        this.stage.addActor(this.table);
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(game.universalInputProcessor);
        inputMultiplexer.addProcessor(this.stage);
        Gdx.input.setInputProcessor(inputMultiplexer);
    }

    private void createLeaderboard() {
        this.leaderboardRows = new Label[12];
        this.leaderboardRows[5] = new Label((CharSequence)"-- Name --", SKIN);
        this.leaderboardRows[6] = new Label((CharSequence)"-- Score --", SKIN);
        this.table.row();
        this.table.add(this.leaderboardRows[5]);
        this.table.add(this.leaderboardRows[6]);
        this.table.row();
        for (int i = 1; i < 10; i += 2) {
            LeaderboardScore score = this.leaderboard.getScore(i / 2);
            if (score == null) {
                this.leaderboardRows[i] = new Label((CharSequence)(i / 2 + 1 + ". -- empty --"), SKIN);
                this.leaderboardRows[i + 1] = new Label((CharSequence)"-- empty --", SKIN);
            } else {
                this.leaderboardRows[i] = new Label((CharSequence)(i / 2 + 1 + ". " + score.getName()), SKIN);
                this.leaderboardRows[i + 1] = new Label((CharSequence)Double.toString(score.getScore()), SKIN);
            }
            this.table.row();
            this.table.add(this.leaderboardRows[i]);
            this.table.add(this.leaderboardRows[i + 1]);
        }
        this.table.row();
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.width = width;
        this.height = height;
        float guiScale = (float)height * 0.75f;
        this.backButtonCell.width(guiScale / 3.0f).height((float)height * 0.06f);
        this.titleCell.width((float)height * 0.45f).height((float)height * 0.08f);
        for (Cell cell : this.table.getCells()) {
            if (cell.getActor() instanceof TextButton) {
                ((TextButton)cell.getActor()).getLabel().setFontScale((float)height * 0.0015f);
                cell.pad((float)height * 0.04f);
                continue;
            }
            if (!(cell.getActor() instanceof Label)) continue;
            ((Label)cell.getActor()).setFontScale((float)height * 0.0015f);
            cell.pad((float)height * 0.02f);
        }
    }
}

