/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import lombok.Generated;
import y111studios.AssetPaths;
import y111studios.BuildingMenu;
import y111studios.GameOverMenu;
import y111studios.GameState;
import y111studios.InfoBar;
import y111studios.Main;
import y111studios.World;
import y111studios.WorldInputProcessor;
import y111studios.achievements.AchievementManager;
import y111studios.buildings.BuildingFactory;
import y111studios.buildings.premade_variants.MiscellaneousVariant;
import y111studios.buildings.premade_variants.VariantProperties;
import y111studios.notification.NotificationManager;

public class MapScreen
extends ScreenAdapter {
    private int width = 640;
    private int height = 480;
    public static final int TILE_WIDTH = 76;
    public static final int TILE_HEIGHT = 76;
    final Main game;
    private final InfoBar infoBar;
    GameState gameState;
    Viewport viewport;
    Texture pauseMenu;
    GameOverMenu gameOverMenu;
    World world;
    private Table table = new Table();
    BuildingMenu buildingMenu;
    private NotificationManager notificationManager;
    private AchievementManager achievementManager;
    InputMultiplexer inputMultiplexer;
    Stage stage = new Stage(new ScreenViewport());

    public MapScreen(Main game) {
        this.game = game;
        this.gameState = new GameState(76, 76, game);
        this.viewport = new FitViewport(this.width, this.height);
        this.viewport.getCamera().position.set((float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f);
        this.viewport.getCamera().update();
        this.pauseMenu = game.getAsset(AssetPaths.PAUSE);
        this.world = new World(game, this.gameState, this);
        this.buildingMenu = new BuildingMenu(game, this.stage);
        this.infoBar = new InfoBar(this.gameState, game, this.stage);
        this.gameOverMenu = null;
        this.table.top().right();
        this.notificationManager = new NotificationManager(this.table, game);
        this.achievementManager = new AchievementManager(this.world);
        this.achievementManager.setupAchievements();
        this.stage.addActor(this.table);
        this.inputMultiplexer = new InputMultiplexer();
        this.inputMultiplexer.addProcessor(game.universalInputProcessor);
        this.inputMultiplexer.addProcessor(this.stage);
        this.inputMultiplexer.addProcessor(new WorldInputProcessor(this.world, this.buildingMenu));
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.inputMultiplexer);
    }

    @Override
    public void render(float delta) {
        this.game.spritebatch.setProjectionMatrix(this.viewport.getCamera().combined);
        if (this.buildingMenu.getCurrentMenuItem() >= 0 && this.buildingMenu.getCurrentMenuItem() < 5) {
            VariantProperties variant = this.buildingMenu.getBuildingVariants().get((Object)this.buildingMenu.getCurrentMenuTab())[this.buildingMenu.getCurrentMenuItem()];
            if (variant == MiscellaneousVariant.ROAD_BEND2 && this.buildingMenu.isFlipped()) {
                this.world.setSelectedBuilding(BuildingFactory.createBuilding(MiscellaneousVariant.ROAD_BEND2_FLIPPED, this.world.currentGridPosition(), this.buildingMenu.isFlipped()));
            } else {
                this.world.setSelectedBuilding(BuildingFactory.createBuilding(variant, this.world.currentGridPosition(), this.buildingMenu.isFlipped()));
            }
        } else {
            this.world.setSelectedBuilding(null);
        }
        this.gameState.tick();
        if (!this.gameState.isPaused()) {
            this.notificationManager.tick();
            this.achievementManager.checkConditions();
        }
        if (this.gameState.getTimer().isTimeUp() && this.gameOverMenu == null) {
            this.gameOverMenu = new GameOverMenu(this.gameState, this.game, this.stage);
            this.buildingMenu.removeActors();
        }
        this.world.render(delta);
        if (this.gameOverMenu == null) {
            this.buildingMenu.render();
        } else {
            this.gameOverMenu.render();
        }
        this.infoBar.render();
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        this.viewport.update(width, height, true);
        this.stage.getViewport().update(width, height, true);
        this.world.resize(width, height);
        if (this.gameOverMenu == null) {
            this.buildingMenu.resize(width, height);
        } else {
            this.gameOverMenu.resize(width, height);
        }
        this.table.setSize(width, (float)height * 0.9f);
        this.stage.getViewport().update(width, height, true);
        this.infoBar.resize(width, height);
        this.notificationManager.resize(width, height);
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.game.dispose();
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public InfoBar getInfoBar() {
        return this.infoBar;
    }

    @Generated
    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Generated
    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }
}

