/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens;

import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.screens.StartScreen;

public abstract class ScreenWithBackground
extends ScreenAdapter {
    Main game;
    ScreenViewport viewport;
    Texture background;

    public ScreenWithBackground(Main game) {
        this.game = game;
        this.viewport = new ScreenViewport();
        this.background = (Texture)game.assetLib.manager.get(AssetPaths.START_SCREEN.getPath());
    }

    @Override
    public void render(float delta) {
        this.game.spritebatch.setProjectionMatrix(this.viewport.getCamera().combined);
        this.game.spritebatch.begin();
        float backgroundWidth = (float)this.viewport.getScreenWidth() / (float)this.viewport.getScreenHeight() * (float)this.background.getHeight();
        this.game.spritebatch.draw(this.background, 0.0f, 0.0f, (float)this.viewport.getScreenWidth(), (float)this.viewport.getScreenHeight(), (int)((double)this.background.getWidth() / 2.0 - (double)backgroundWidth / 2.0), 0, (int)backgroundWidth, this.background.getHeight(), false, false);
        this.game.spritebatch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
    }

    public static TextButton backButton(Skin skin, final Main game) {
        TextButton backButton = new TextButton("Return to Menu", skin);
        backButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                game.setScreen(new StartScreen(game));
                return false;
            }
        });
        return backButton;
    }
}

