/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import y111studios.AssetPaths;
import y111studios.Main;
import y111studios.screens.InstructionsScreen;
import y111studios.screens.LeaderboardScreen;
import y111studios.screens.MapScreen;
import y111studios.screens.ScreenWithBackground;

public class StartScreen
extends ScreenWithBackground {
    final Main game;
    Texture background;
    Stage stage;
    Table table;
    Skin skin = new Skin(Gdx.files.internal("assets/skins/default/uiskin.json"));
    Image logo;
    Cell<Image> logoCell;
    Button playButton;
    Cell<Button> playButtonCell;
    Button leaderboardButton;
    Cell<Button> leaderboardButtonCell;
    Button instructionsButton;
    Cell<Button> instructionsButtonCell;
    Button quitButton;
    Cell<Button> quitButtonCell;

    public StartScreen(Main game) {
        super(game);
        this.game = game;
        this.stage = new Stage(this.viewport);
        this.createMenu();
        InputMultiplexer inputMultiplexer = new InputMultiplexer();
        inputMultiplexer.addProcessor(game.universalInputProcessor);
        inputMultiplexer.addProcessor(this.stage);
        Gdx.input.setInputProcessor(inputMultiplexer);
    }

    private void createMenu() {
        this.table = new Table();
        this.table.setFillParent(true);
        this.logo = new Image(this.game.getAsset(AssetPaths.UNISIM_LOGO));
        TextButton playButton = new TextButton("New Game", this.skin);
        playButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                StartScreen.this.game.setScreen(new MapScreen(StartScreen.this.game));
                return false;
            }
        });
        this.leaderboardButton = new TextButton("Leaderboard", this.skin);
        this.leaderboardButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                StartScreen.this.game.setScreen(new LeaderboardScreen(StartScreen.this.game));
                return false;
            }
        });
        this.instructionsButton = new TextButton("Instructions", this.skin);
        this.instructionsButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                StartScreen.this.game.setScreen(new InstructionsScreen(StartScreen.this.game, null));
                return false;
            }
        });
        this.quitButton = new TextButton("Quit", this.skin);
        this.quitButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent e, float x, float y, int pointer, int button) {
                Gdx.app.exit();
                return false;
            }
        });
        this.logoCell = this.table.add(this.logo).colspan(2);
        this.table.row();
        this.playButtonCell = this.table.add(playButton).colspan(2);
        this.table.row().height((float)this.viewport.getScreenHeight() * 0.25f);
        this.leaderboardButtonCell = this.table.add(this.leaderboardButton);
        this.instructionsButtonCell = this.table.add(this.instructionsButton);
        this.table.row();
        this.quitButtonCell = this.table.add(this.quitButton).colspan(2);
        this.stage.addActor(this.table);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        super.render(delta);
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        float guiScale = (float)height * 0.75f;
        this.table.setSize(width, height);
        this.logoCell.width((float)height * 0.8f).height((float)height * 0.25f);
        this.playButtonCell.width(guiScale).height((float)height * 0.06f);
        this.leaderboardButtonCell.width(guiScale / 2.0f).height((float)height * 0.06f);
        this.instructionsButtonCell.width(guiScale / 2.0f).height((float)height * 0.06f);
        this.quitButtonCell.width(guiScale / 2.0f).height((float)height * 0.06f);
        for (Cell cell : this.table.getCells()) {
            if (!(cell.getActor() instanceof TextButton)) continue;
            ((TextButton)cell.getActor()).getLabel().setFontScale((float)height * 0.0015f);
        }
        this.playButtonCell.pad((float)this.viewport.getScreenHeight() * 0.02f);
        this.leaderboardButtonCell.pad((float)this.viewport.getScreenHeight() * 0.02f);
        this.instructionsButtonCell.pad((float)this.viewport.getScreenHeight() * 0.02f);
        this.quitButtonCell.pad((float)this.viewport.getScreenHeight() * 0.02f);
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.game.dispose();
    }
}

