/*
 * Decompiled with CFR 0.152.
 */
package y111studios.screens.leaderboard;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import y111studios.screens.leaderboard.LeaderboardScore;
import y111studios.screens.leaderboard.Scores;

public class Leaderboard {
    public static final int MAX_SIZE = 5;
    List<LeaderboardScore> scores = new ArrayList<LeaderboardScore>(5);
    boolean persistent;
    FileHandle leaderboardFile;

    public Leaderboard(boolean persistent) {
        String leaderboardJson;
        this.persistent = persistent;
        if (!persistent) {
            return;
        }
        Gdx.app.log("#INFO", Gdx.files.getLocalStoragePath());
        this.leaderboardFile = Gdx.files.local("data/leaderboard.json");
        if (this.leaderboardFile.exists() && (leaderboardJson = this.leaderboardFile.readString()) != null && leaderboardJson != "") {
            this.loadJson(leaderboardJson);
        }
    }

    public boolean insertScore(LeaderboardScore score) {
        if (score.getScore() < 0.0 || score.getName() == null || score.getName() == "") {
            return false;
        }
        this.scores.add(score);
        this.scores.sort(new SortByScore());
        while (this.scores.size() > 5) {
            this.scores.remove(5);
        }
        return this.scores.contains(score);
    }

    public void saveJson() {
        if (!this.persistent) {
            return;
        }
        Json json = new Json();
        Scores currentScores = new Scores();
        currentScores.setScores(this.scores);
        OutputStream stream = this.leaderboardFile.write(false);
        String jsonStr = json.toJson(currentScores);
        try {
            stream.write(jsonStr.getBytes(), 0, jsonStr.length());
        }
        catch (IOException e) {
            Gdx.app.log("#WARN", "Failed to save JSON");
            return;
        }
    }

    public void loadJson(String jsonStr) {
        Json json = new Json();
        Scores loadedScores = json.fromJson(Scores.class, jsonStr);
        if (loadedScores == null) {
            Gdx.app.log("#WARN", "Failed to load leaderboard JSON, falling back to empty leaderboard");
            this.scores = new ArrayList<LeaderboardScore>();
            return;
        }
        this.scores = loadedScores.getScores();
    }

    public void clearLeaderboard() {
        this.scores.clear();
    }

    public List<LeaderboardScore> getScores() {
        return this.scores;
    }

    public int getSize() {
        return this.scores.size();
    }

    public LeaderboardScore getScore(int index) {
        if (index < 0 || index >= this.scores.size()) {
            return null;
        }
        return this.scores.get(index);
    }

    class SortByScore
    implements Comparator<LeaderboardScore> {
        SortByScore() {
        }

        @Override
        public int compare(LeaderboardScore a, LeaderboardScore b) {
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return a.getScore() > b.getScore() ? -1 : 1;
        }
    }
}

